/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.animation.types.attack;

import com.epicfight.animation.Animator;
import com.epicfight.animation.types.attack.AttackAnimation;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.physics.Collider;
import com.epicfight.utils.game.AttackResult;
import com.epicfight.utils.math.Mat4f;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public class MountAttackAnimation
extends AttackAnimation {
    public MountAttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, Collider collider, String index, String path) {
        super(id, convertTime, antic, preDelay, contact, recovery, false, collider, index, path);
    }

    @Override
    public void onActivate(EntitydataFighter entitydata) {
        entitydata.motionUpdateLoop = false;
        entitydata.attackToggle = true;
        entitydata.lastDealtDamageAmount = 0.0f;
    }

    @Override
    public void onUpdate(EntitydataFighter entitydata) {
        float elapsedTime = ((Animator)entitydata.getAnimator()).getElapsedTime();
        if (elapsedTime > this.preDelay && (elapsedTime < this.contact || entitydata.attackToggle)) {
            if (entitydata.attackToggle) {
                entitydata.getOriginalEntity().func_184185_a(this.getAttackSound(entitydata), 1.0f, 1.0f);
                entitydata.attackToggle = false;
            }
            if (!entitydata.isRemote()) {
                Collider collider = this.getCollider(entitydata);
                entitydata.getEntityModel().getArmature().initializeTransform();
                Mat4f jointTransform = entitydata.getServerAnimator().getColliderTransformMatrix(this.jointIndexer);
                collider.transform(Mat4f.mul(entitydata.getModelMatrix(), jointTransform, null));
                List list = ((EntityLivingBase)entitydata.getOriginalEntity()).field_70170_p.func_72839_b(entitydata.getOriginalEntity(), collider.getHitboxAABB());
                collider.extractHitEntities(list);
                if (list.size() > 0) {
                    AttackResult attackResult = new AttackResult((Entity)entitydata.getOriginalEntity(), list);
                    int i = 0;
                    while (entitydata.currentlyAttackedEntity.size() < this.getHitEnemies(entitydata)) {
                        Entity e = attackResult.getEntity();
                        if (!entitydata.currentlyAttackedEntity.contains(e) && !entitydata.isTeam(e) && e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70685_l(entitydata.getOriginalEntity())) {
                            if (e.func_70097_a((DamageSource)this.getDamageSourceExt(entitydata), this.getDamageAmount(entitydata, e))) {
                                entitydata.hitEntity(e);
                                e.field_70172_ad = 0;
                                e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, entitydata.getWeaponHitSound(), e.func_184176_by(), 1.0f, 1.0f);
                                if (i == 0 && entitydata instanceof EntitydataPlayer) {
                                    entitydata.getOriginalEntity().func_184614_ca().func_77961_a((EntityLivingBase)e, (EntityPlayer)((EntitydataPlayer)entitydata).getOriginalEntity());
                                }
                                ++i;
                            }
                            entitydata.currentlyAttackedEntity.add(e);
                        }
                        if (attackResult.next()) continue;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void onFinish(EntitydataFighter entitydata, boolean isEnd) {
        entitydata.motionUpdateLoop = true;
        entitydata.currentlyAttackedEntity.clear();
    }
}

