/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.entity;

import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.gamedata.Colliders;
import com.epicfight.gamedata.Sounds;
import com.epicfight.item.ModItems;
import com.epicfight.physics.Collider;
import com.epicfight.utils.game.DamageAttributes;
import com.epicfight.utils.game.IExtendedDamageSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;

public abstract class EntitydataFighter<T extends EntityLivingBase>
extends EntitydataLiving<T> {
    public boolean attackToggle;
    public float lastDealtDamageAmount;
    public List<Entity> currentlyAttackedEntity;
    protected DamageAttributes damageAttributes;

    @Override
    public void init() {
        super.init();
        this.attackToggle = true;
        this.currentlyAttackedEntity = new ArrayList<Entity>();
        this.damageAttributes = new DamageAttributes();
        this.damageAttributes.addAttribute(DamageAttributes.IMPACT, 0.5);
        this.damageAttributes.addAttribute(DamageAttributes.DEFENCE_IGNORE, 0.0);
        this.damageAttributes.addAttribute(DamageAttributes.MULTIPLE_HIT, 1.0);
    }

    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType) {
        return IExtendedDamageSource.causeMobDamage((EntityLivingBase)this.orgEntity, stunType);
    }

    public float getDamageToEntity(Entity targetEntity) {
        float damage = (float)((EntityLivingBase)this.orgEntity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float modifier = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)((EntityLivingBase)this.orgEntity).func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)((EntityLivingBase)this.orgEntity).func_184614_ca(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
        return damage + modifier;
    }

    public void hitEntity(Entity hitTarget) {
    }

    public SoundEvent getWeaponHitSound() {
        CapabilityItem cap = this.getHeldItemCapability(EnumHand.MAIN_HAND);
        if (cap != null) {
            return cap.getHitSound();
        }
        return Sounds.BLUNT_HIT;
    }

    public SoundEvent getAttackSound() {
        CapabilityItem cap = this.getHeldItemCapability(EnumHand.MAIN_HAND);
        if (cap != null) {
            return cap.getSmashingSound();
        }
        return Sounds.WHOOSH;
    }

    public DamageAttributes getDamageAttributes() {
        return this.damageAttributes;
    }

    public Collider getColliderMatching() {
        CapabilityItem itemCap = this.getHeldItemCapability(EnumHand.MAIN_HAND);
        return itemCap != null ? itemCap.getWeaponCollider() : Colliders.fist;
    }

    public int getHitEnemies() {
        DamageAttributes itemDamageAttributes = ModItems.getItemDamageAttribute(((EntityLivingBase)this.orgEntity).func_184614_ca(), ((EntityLivingBase)this.orgEntity).func_184592_cb().func_190926_b());
        if (itemDamageAttributes != null) {
            return itemDamageAttributes.getHitEnemies();
        }
        return this.damageAttributes.getHitEnemies();
    }

    public float getDefenceIgnore() {
        DamageAttributes itemDamageAttributes = ModItems.getItemDamageAttribute(((EntityLivingBase)this.orgEntity).func_184614_ca(), ((EntityLivingBase)this.orgEntity).func_184592_cb().func_190926_b());
        if (itemDamageAttributes != null) {
            return itemDamageAttributes.getDefenceIgnore();
        }
        return this.damageAttributes.getDefenceIgnore();
    }

    public boolean isTeam(Entity entityIn) {
        if (((EntityLivingBase)this.orgEntity).func_184187_bx() != null && ((EntityLivingBase)this.orgEntity).func_184187_bx().equals((Object)entityIn)) {
            return true;
        }
        if (((EntityLivingBase)this.orgEntity).func_184215_y(entityIn)) {
            return true;
        }
        return ((EntityLivingBase)this.orgEntity).func_184191_r(entityIn);
    }

    public float getImpact() {
        DamageAttributes itemDamageAttributes = ModItems.getItemDamageAttribute(((EntityLivingBase)this.orgEntity).func_184614_ca(), ((EntityLivingBase)this.orgEntity).func_184592_cb().func_190926_b());
        if (itemDamageAttributes != null) {
            return itemDamageAttributes.getImpact();
        }
        return this.damageAttributes.getImpact();
    }
}

