/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.entity;

import com.epicfight.animation.Animator;
import com.epicfight.animation.AnimatorServer;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.CapabilityEntity;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.gamedata.Animations;
import com.epicfight.main.ModCore;
import com.epicfight.model.Model;
import com.epicfight.utils.game.IExtendedDamageSource;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntitydataLiving<T extends EntityLivingBase>
extends CapabilityEntity<T> {
    protected boolean inaction;
    public boolean motionUpdateLoop;
    public Vec3f prevPosition;
    public AnimatorClient.LivingMotion currentMotion = AnimatorClient.LivingMotion.IDLE;
    public AnimatorClient.LivingMotion currentMixMotion = AnimatorClient.LivingMotion.NONE;
    protected Animator animator;
    private float knockbackTimeReduction;
    protected static final IAttribute MAX_STUN_RESISTANCE = new RangedAttribute((IAttribute)null, "stun resistance", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    protected static final IAttribute WEIGHT = new RangedAttribute((IAttribute)null, "weight", 0.0, 0.0, Double.MAX_VALUE).func_111112_a(true);
    protected static final DataParameter<Float> STUN_RESISTANCE = new DataParameter(254, DataSerializers.field_187193_c);

    @Override
    public void init() {
        if (((EntityLivingBase)this.orgEntity).field_70170_p.field_72995_K) {
            this.motionUpdateLoop = true;
            this.animator = new AnimatorClient(this);
            this.initAnimator(this.getClientAnimator());
        } else {
            this.animator = new AnimatorServer(this);
        }
        this.inaction = false;
        this.prevPosition = new Vec3f();
        AbstractAttributeMap attributeMap = ((EntityLivingBase)this.orgEntity).func_110140_aT();
        if (attributeMap.func_111151_a(WEIGHT) == null) {
            attributeMap.func_111150_b(WEIGHT).func_111128_a((double)((EntityLivingBase)this.orgEntity).func_110138_aP() * 2.0);
        }
    }

    protected abstract void initAnimator(AnimatorClient var1);

    public abstract void updateMotion();

    public abstract Model getEntityModel();

    @Override
    protected void updateOnClient() {
        AnimatorClient animator = this.getClientAnimator();
        if (this.motionUpdateLoop) {
            this.updateMotion();
            if (!animator.compareMotion(this.currentMotion)) {
                animator.playLoopMotion();
            }
            if (!animator.compareMixMotion(this.currentMixMotion)) {
                animator.playMixLoopMotion();
            }
        }
    }

    @Override
    protected void updateOnServer() {
        if (this.knockbackTimeReduction > 0.0f) {
            this.knockbackTimeReduction = Math.max(0.0f, this.knockbackTimeReduction - 0.05f);
        }
    }

    @Override
    public void update() {
        if (this.isRemote()) {
            this.updateOnClient();
        } else {
            this.updateOnServer();
        }
        this.animator.update();
        this.inaction = this.getEntityState() != EntityState.FREE;
        if (((EntityLivingBase)this.orgEntity).field_70725_aQ == 19) {
            this.aboutToDeath();
        }
    }

    protected final void commonBipedCreatureAnimatorInit(AnimatorClient animator) {
        animator.addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.BIPED_WALK);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.DEATH, Animations.BIPED_DEATH);
    }

    protected final void commonBipedCreatureUpdateMotion() {
        this.currentMotion = ((EntityLivingBase)this.orgEntity).func_184218_aH() ? AnimatorClient.LivingMotion.MOUNT : (((EntityLivingBase)this.orgEntity).field_70181_x < (double)-0.55f ? AnimatorClient.LivingMotion.FALL : (((EntityLivingBase)this.orgEntity).field_70721_aZ > 0.01f ? AnimatorClient.LivingMotion.WALKING : AnimatorClient.LivingMotion.IDLE));
    }

    public void cancelUsingItem() {
        if (this.orgEntity != null) {
            ((EntityLivingBase)this.orgEntity).func_184602_cy();
            ForgeEventFactory.onUseItemStop((EntityLivingBase)((EntityLivingBase)this.orgEntity), (ItemStack)((EntityLivingBase)this.orgEntity).func_184607_cu(), (int)((EntityLivingBase)this.orgEntity).func_184605_cv());
        }
    }

    public CapabilityItem getHeldItemCapability(EnumHand hand) {
        CapabilityItem itemCap = (CapabilityItem)((EntityLivingBase)this.orgEntity).func_184586_b(hand).getCapability(ModCapabilities.CAPABILITY_ITEM, null);
        return itemCap;
    }

    public boolean isInaction() {
        return this.inaction;
    }

    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        float currentStunResistance = this.getStunResistance();
        if (currentStunResistance > 0.0f && damageSource instanceof IExtendedDamageSource) {
            float impact = Math.max(((IExtendedDamageSource)damageSource).getImpact(), 0.5f);
            ((EntityLivingBase)this.orgEntity).func_184212_Q().func_187227_b(STUN_RESISTANCE, (Object)Float.valueOf(currentStunResistance - amount * impact));
        }
        return true;
    }

    public void setKnockbackReduction() {
        this.knockbackTimeReduction += (1.0f - this.knockbackTimeReduction) * 0.8f;
    }

    public float getKnockbackTimeReduction() {
        return this.knockbackTimeReduction;
    }

    public void knockBackEntity(Entity entityIn, float power) {
        double d1 = entityIn.field_70165_t - ((EntityLivingBase)this.orgEntity).field_70165_t;
        double d0 = entityIn.field_70161_v - ((EntityLivingBase)this.orgEntity).field_70161_v;
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if (((EntityLivingBase)this.orgEntity).func_70681_au().nextDouble() >= ((EntityLivingBase)this.orgEntity).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            ((EntityLivingBase)this.orgEntity).field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0));
            ((EntityLivingBase)this.orgEntity).field_70159_w /= 2.0;
            ((EntityLivingBase)this.orgEntity).field_70179_y /= 2.0;
            ((EntityLivingBase)this.orgEntity).field_70159_w -= d1 / (double)f * (double)power;
            ((EntityLivingBase)this.orgEntity).field_70179_y -= d0 / (double)f * (double)power;
            if (!((EntityLivingBase)this.orgEntity).field_70122_E) {
                ((EntityLivingBase)this.orgEntity).field_70181_x /= 2.0;
                ((EntityLivingBase)this.orgEntity).field_70181_x += (double)power;
                if (((EntityLivingBase)this.orgEntity).field_70181_x > (double)0.4f) {
                    ((EntityLivingBase)this.orgEntity).field_70181_x = 0.4f;
                }
            }
        }
    }

    public float getMaxStunResistance() {
        IAttributeInstance stun_resistance = ((EntityLivingBase)this.orgEntity).func_110140_aT().func_111151_a(MAX_STUN_RESISTANCE);
        return (float)(stun_resistance == null ? 0.0 : stun_resistance.func_111126_e());
    }

    public float getStunResistance() {
        return this.getMaxStunResistance() == 0.0f ? 0.0f : MathHelper.func_76131_a((float)((Float)((EntityLivingBase)this.orgEntity).func_184212_Q().func_187225_a(STUN_RESISTANCE)).floatValue(), (float)0.0f, (float)((float)((EntityLivingBase)this.orgEntity).func_110140_aT().func_111151_a(MAX_STUN_RESISTANCE).func_111126_e()));
    }

    public double getWeight() {
        return ((EntityLivingBase)this.orgEntity).func_110140_aT().func_111151_a(WEIGHT).func_111126_e();
    }

    public void rotateTo(float degree, float limit, boolean partialSync) {
        float f1;
        T entity = this.getOriginalEntity();
        float orgRotation = ((EntityLivingBase)entity).field_70177_z;
        float amount = MathHelper.func_76142_g((float)(degree - orgRotation));
        if (amount > limit) {
            amount = limit;
        }
        if (amount < -limit) {
            amount = -limit;
        }
        if ((f1 = orgRotation + amount) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        if (partialSync) {
            ((EntityLivingBase)entity).field_70126_B = f1;
            ((EntityLivingBase)entity).field_70758_at = f1;
            ((EntityLivingBase)entity).field_70760_ar = f1;
        }
        ((EntityLivingBase)entity).field_70177_z = f1;
        ((EntityLivingBase)entity).field_70759_as = f1;
        ((EntityLivingBase)entity).field_70761_aq = f1;
    }

    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.field_70165_t - ((EntityLivingBase)this.orgEntity).field_70165_t;
        double d1 = target.field_70161_v - ((EntityLivingBase)this.orgEntity).field_70161_v;
        float degree = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
        this.rotateTo(degree, limit, partialSync);
    }

    public void moveForward(float forward) {
        T entity = this.getOriginalEntity();
        float x = -forward * MathHelper.func_76126_a((float)(((EntityLivingBase)entity).field_70177_z * ((float)Math.PI / 180)));
        float z = forward * MathHelper.func_76134_b((float)(((EntityLivingBase)entity).field_70177_z * ((float)Math.PI / 180)));
        entity.func_70091_d(MoverType.SELF, (double)x, 0.0, (double)z);
    }

    public void move(float horizontal, float vertical) {
        T entity = this.getOriginalEntity();
        float x = -horizontal * MathHelper.func_76126_a((float)(((EntityLivingBase)entity).field_70177_z * ((float)Math.PI / 180)));
        float z = horizontal * MathHelper.func_76134_b((float)(((EntityLivingBase)entity).field_70177_z * ((float)Math.PI / 180)));
        entity.func_70091_d(MoverType.SELF, (double)x, (double)vertical, (double)z);
    }

    public Mat4f getHeadMatrix() {
        float f2;
        float partialTick = ModCore.partialTick;
        if (this.inaction) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(((EntityLivingBase)this.orgEntity).field_70760_ar, ((EntityLivingBase)this.orgEntity).field_70761_aq, partialTick);
            float f1 = MathUtils.interpolateRotation(((EntityLivingBase)this.orgEntity).field_70758_at, ((EntityLivingBase)this.orgEntity).field_70759_as, partialTick);
            f2 = f1 - f;
            if (((EntityLivingBase)this.orgEntity).func_184218_aH()) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((EntityLivingBase)this.orgEntity).field_70127_C, ((EntityLivingBase)this.orgEntity).field_70125_A, f2, f2);
    }

    public void resetLivingMixLoop() {
        this.currentMixMotion = AnimatorClient.LivingMotion.NONE;
        this.getClientAnimator().resetMixMotion();
    }

    @Override
    public Mat4f getModelMatrix() {
        float rotyaw;
        float prevRotYaw;
        if (((EntityLivingBase)this.orgEntity).func_184218_aH()) {
            if (((EntityLivingBase)this.orgEntity).func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase ridingEntity = (EntityLivingBase)((EntityLivingBase)this.orgEntity).func_184187_bx();
                prevRotYaw = ridingEntity.field_70760_ar;
                rotyaw = ridingEntity.field_70761_aq;
            } else {
                prevRotYaw = ((EntityLivingBase)this.orgEntity).func_184187_bx().field_70126_B;
                rotyaw = ((EntityLivingBase)this.orgEntity).func_184187_bx().field_70177_z;
            }
        } else {
            prevRotYaw = this.inaction ? ((EntityLivingBase)this.orgEntity).field_70177_z : ((EntityLivingBase)this.orgEntity).field_70760_ar;
            rotyaw = this.inaction ? ((EntityLivingBase)this.orgEntity).field_70177_z : ((EntityLivingBase)this.orgEntity).field_70761_aq;
        }
        return MathUtils.getModelMatrixIntegrated((float)((EntityLivingBase)this.orgEntity).field_70142_S, (float)((EntityLivingBase)this.orgEntity).field_70165_t, (float)((EntityLivingBase)this.orgEntity).field_70137_T, (float)((EntityLivingBase)this.orgEntity).field_70163_u, (float)((EntityLivingBase)this.orgEntity).field_70136_U, (float)((EntityLivingBase)this.orgEntity).field_70161_v, 0.0f, 0.0f, prevRotYaw, rotyaw);
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    public AnimatorClient getClientAnimator() {
        return (AnimatorClient)this.getAnimator();
    }

    public AnimatorServer getServerAnimator() {
        return (AnimatorServer)this.getAnimator();
    }

    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (((EntityLivingBase)this.orgEntity).func_184218_aH()) {
            return Animations.BIPED_MOUNT_HIT;
        }
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.BIPED_HIT_LONG;
        }
        return Animations.BIPED_HIT_SHORT;
    }

    @Override
    public void aboutToDeath() {
        this.animator.onEntityDeath();
        this.animator = null;
        super.aboutToDeath();
    }

    @Override
    public T getOriginalEntity() {
        return (T)((EntityLivingBase)this.orgEntity);
    }

    public EntityState getEntityState() {
        return this.animator.getPlayAnimation().getState(this.animator.getElapsedTime());
    }

    public static enum EntityState {
        FREE,
        INACTION,
        ANTIC,
        CONTACT,
        RECOVERY,
        HIT;

    }
}

