/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.entity.mob;

import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.animation.types.attack.AttackAnimation;
import com.epicfight.capabilities.entity.mob.EntitydataBipedMob;
import com.epicfight.capabilities.entity.mob.MobAttackPatterns;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.entity.ai.EntityAIAttackPattern;
import com.epicfight.entity.ai.EntityAIChase;
import com.epicfight.entity.ai.EntityAIPatternProbability;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Models;
import com.epicfight.model.Model;
import com.epicfight.network.PacketManager;
import com.epicfight.network.server.STCPlayAnimationTP;
import com.epicfight.network.server.STCPlayAnimationTarget;
import com.epicfight.potion.ModPotions;
import com.epicfight.utils.game.IExtendedDamageSource;
import com.epicfight.utils.math.Vec3f;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntitydataEnderman
extends EntitydataBipedMob<EntityEnderman> {
    private int deathTimerExt = 0;
    private int teleportCooled = 0;
    private boolean onRage;
    private EntityAIBase normalAttack1;
    private EntityAIBase normalAttack2;
    private EntityAIBase normalAttack3;
    private EntityAIBase rageTarget;
    private EntityAIBase rageChase;
    private static DataParameter<Boolean> SCREAMING;

    @Override
    public void init() {
        super.init();
        AbstractAttributeMap attributeMap = ((EntityEnderman)this.orgEntity).func_110140_aT();
        if (attributeMap.func_111151_a(MAX_STUN_RESISTANCE) == null) {
            attributeMap.func_111150_b(MAX_STUN_RESISTANCE).func_111128_a(15.0);
            ((EntityEnderman)this.orgEntity).func_184212_Q().func_187214_a(STUN_RESISTANCE, (Object)Float.valueOf(15.0f));
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.isRemote()) {
            if (this.isRaging()) {
                this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.ENDERMAN_RAGE_IDLE);
                this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.ENDERMAN_RAGE_WALK);
                this.onRage = true;
            } else {
                this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
                this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.ENDERMAN_WALK);
                this.onRage = false;
            }
        }
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttack1 = new EntityAIPatternProbability(this, (EntityCreature)this.orgEntity, 4.0, 4.5, 0.6f, true, MobAttackPatterns.ENDERMAN_PATTERN2);
        this.normalAttack2 = new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 3.5, true, MobAttackPatterns.ENDERMAN_PATTERN1);
        this.normalAttack3 = new AIEndermanTeleportKick(this, (EntityMob)this.orgEntity);
        this.rageTarget = new EntityAINearestAttackableTarget((EntityCreature)this.orgEntity, EntityPlayer.class, true);
        this.rageChase = new AIEndermanRush(this, (EntityMob)this.orgEntity);
    }

    @Override
    protected void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(AnimatorClient.LivingMotion.DEATH, Animations.ENDERMAN_DEATH);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.ENDERMAN_WALK);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
    }

    @Override
    public void updateMotion() {
        this.currentMotion = ((EntityEnderman)this.orgEntity).field_70721_aZ > 0.01f ? AnimatorClient.LivingMotion.WALKING : AnimatorClient.LivingMotion.IDLE;
    }

    @Override
    public void update() {
        if (((EntityEnderman)this.orgEntity).func_110143_aJ() <= 0.0f) {
            ((EntityEnderman)this.orgEntity).field_70125_A = 0.0f;
            if (((EntityEnderman)this.orgEntity).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((EntityEnderman)this.orgEntity).field_70725_aQ;
            }
        }
        if (this.isRaging() && !this.onRage && ((EntityEnderman)this.orgEntity).field_70173_aa > 5) {
            this.convertRage();
        } else if (this.onRage && !this.isRaging()) {
            this.convertNormal();
        }
        if (this.teleportCooled > 0) {
            --this.teleportCooled;
        }
        super.update();
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        if (damageSource instanceof EntityDamageSource && !this.isRaging() && ((EntityEnderman)this.orgEntity).func_70681_au().nextInt(3) == 0) {
            for (int i = 0; i < 9; ++i) {
                if (!this.teleportRandomly()) continue;
                if (damageSource.func_76346_g() instanceof EntityLivingBase) {
                    ((EntityEnderman)this.orgEntity).func_70604_c((EntityLivingBase)damageSource.func_76346_g());
                }
                return false;
            }
        }
        return super.attackEntityFrom(damageSource, amount);
    }

    protected boolean teleportRandomly() {
        double d0 = ((EntityEnderman)this.orgEntity).field_70165_t + (((EntityEnderman)this.orgEntity).func_70681_au().nextDouble() - 0.5) * 64.0;
        double d1 = ((EntityEnderman)this.orgEntity).field_70163_u + (double)(((EntityEnderman)this.orgEntity).func_70681_au().nextInt(64) - 32);
        double d2 = ((EntityEnderman)this.orgEntity).field_70161_v + (((EntityEnderman)this.orgEntity).func_70681_au().nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        boolean flag = ((EntityEnderman)this.orgEntity).func_184595_k(x, y, z);
        if (flag) {
            ((EntityEnderman)this.orgEntity).field_70170_p.func_184148_a((EntityPlayer)null, ((EntityEnderman)this.orgEntity).field_70169_q, ((EntityEnderman)this.orgEntity).field_70167_r, ((EntityEnderman)this.orgEntity).field_70166_s, SoundEvents.field_187534_aX, ((EntityEnderman)this.orgEntity).func_184176_by(), 1.0f, 1.0f);
            ((EntityEnderman)this.orgEntity).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean isRaging() {
        return ((EntityEnderman)this.orgEntity).func_110143_aJ() / ((EntityEnderman)this.orgEntity).func_110138_aP() < 0.33f;
    }

    protected void convertRage() {
        this.onRage = true;
        this.animator.playAnimation(Animations.ENDERMAN_HIT_RAGE, 0.0f);
        if (this.isRemote()) {
            this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.ENDERMAN_RAGE_IDLE);
            this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.ENDERMAN_RAGE_WALK);
        } else if (!((EntityEnderman)this.orgEntity).func_175446_cd()) {
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack1);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack2);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack3);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.rageChase);
            ((EntityEnderman)this.orgEntity).field_70715_bh.func_75776_a(3, this.rageTarget);
            ((EntityEnderman)this.orgEntity).func_184212_Q().func_187227_b(SCREAMING, (Object)true);
            ((EntityEnderman)this.orgEntity).func_70690_d(new PotionEffect(ModPotions.SUPERARMOR_EFFECT, 1000000));
        }
    }

    protected void convertNormal() {
        this.onRage = false;
        if (this.isRemote()) {
            this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
            this.getClientAnimator().addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.ENDERMAN_WALK);
        } else if (!((EntityEnderman)this.orgEntity).func_175446_cd()) {
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack1);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack2);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack3);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.rageChase);
            ((EntityEnderman)this.orgEntity).field_70715_bh.func_85156_a(this.rageTarget);
            if (((EntityEnderman)this.orgEntity).func_70638_az() == null) {
                ((EntityEnderman)this.orgEntity).func_184212_Q().func_187227_b(SCREAMING, (Object)false);
            }
            ((EntityEnderman)this.orgEntity).func_184589_d(ModPotions.SUPERARMOR_EFFECT);
        }
    }

    @Override
    public void setAIAsUnarmed() {
        if (this.isRaging()) {
            ((EntityEnderman)this.orgEntity).field_70715_bh.func_75776_a(3, this.rageTarget);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.rageChase);
        } else {
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack1);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack2);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack3);
        }
        ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 0.75, false));
    }

    @Override
    public void setAIAsArmed() {
        this.setAIAsUnarmed();
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }

    @Override
    public void aboutToDeath() {
        ((EntityEnderman)this.orgEntity).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        super.aboutToDeath();
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.ENDERMAN_HIT_LONG;
        }
        return Animations.ENDERMAN_HIT_SHORT;
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.CLIENT.ENTITY_ENDERMAN : Models.SERVER.ENTITY_ENDERMAN;
    }

    static {
        Field fld = ObfuscationReflectionHelper.findField(EntityEnderman.class, (String)"field_184719_bw");
        fld.setAccessible(true);
        try {
            SCREAMING = (DataParameter)fld.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    static class AIEndermanRush
    extends EntityAIAttackPattern {
        private float accelator;

        public AIEndermanRush(EntitydataBipedMob mobdata, EntityMob attacker) {
            super(mobdata, (EntityCreature)attacker, 0.0, 2.0, false, null);
            super.func_75248_a(8);
        }

        @Override
        public boolean func_75250_a() {
            return this.isValidTarget(this.attacker.func_70638_az()) && !this.mobdata.isInaction();
        }

        @Override
        public boolean func_75253_b() {
            return this.isValidTarget(this.attacker.func_70638_az()) && !this.mobdata.isInaction();
        }

        @Override
        public void func_75249_e() {
            PacketManager.packetHandler.sendToAllTracking((IMessage)new STCPlayAnimationTarget(403, this.attacker.func_145782_y(), -1.0f, true, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
            this.accelator = 0.0f;
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            if (this.isTargetInRange(this.attacker.func_70638_az()) && this.canExecuteAttack()) {
                this.mobdata.getServerAnimator().playAnimation(Animations.ENDERMAN_GRASP, 0.0f);
                PacketManager.packetHandler.sendToAllTracking((IMessage)new STCPlayAnimationTarget(Animations.ENDERMAN_GRASP.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
            }
            this.attacker.func_70661_as().func_75489_a((double)(0.025f * this.accelator * this.accelator + 1.0f));
            this.accelator = this.accelator > 2.0f ? this.accelator : this.accelator + 0.05f;
        }
    }

    static class AIEndermanTeleportKick
    extends EntityAIPatternProbability {
        private int delayCounter;

        public AIEndermanTeleportKick(EntitydataBipedMob mobdata, EntityMob attacker) {
            super(mobdata, (EntityCreature)attacker, 25.0, 10000.0, 0.1f, false, null);
            super.func_75248_a(11);
        }

        @Override
        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
            return this.isValidTarget(entitylivingbase) && this.isTargetInRange(entitylivingbase);
        }

        @Override
        public void func_75249_e() {
            this.delayCounter = 35 + this.attacker.func_70681_au().nextInt(10);
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            EntityLivingBase target = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- == 0 && !this.mobdata.isInaction()) {
                Vec3f vec = new Vec3f((float)(this.attacker.field_70165_t - target.field_70165_t), 0.0f, (float)(this.attacker.field_70161_v - target.field_70161_v));
                vec.normalise();
                vec.scale(1.414f);
                boolean flag = this.attacker.func_184595_k(target.field_70165_t + (double)vec.x, target.field_70163_u, target.field_70161_v + (double)vec.z);
                if (flag) {
                    this.mobdata.rotateTo((Entity)target, 360.0f, true);
                    AttackAnimation kickAnimation = this.attacker.func_70681_au().nextBoolean() ? (AttackAnimation)Animations.ENDERMAN_KICK1 : (AttackAnimation)Animations.ENDERMAN_KICK2;
                    this.mobdata.getServerAnimator().playAnimation(kickAnimation, 0.0f);
                    PacketManager.packetHandler.sendToAllTracking((IMessage)new STCPlayAnimationTP(kickAnimation.getId(), this.attacker.func_145782_y(), -1.0f, this.attacker.func_70638_az().func_145782_y(), this.attacker.field_70165_t, this.attacker.field_70163_u, this.attacker.field_70161_v, this.attacker.field_70177_z), (Entity)this.attacker);
                    this.attacker.field_70170_p.func_184148_a((EntityPlayer)null, this.attacker.field_70169_q, this.attacker.field_70167_r, this.attacker.field_70166_s, SoundEvents.field_187534_aX, this.attacker.func_184176_by(), 1.0f, 1.0f);
                    this.attacker.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        }
    }
}

