/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.entity.player;

import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Classes;
import com.epicfight.gamedata.Models;
import com.epicfight.model.Model;
import com.epicfight.playerclass.PlayerClass;
import com.epicfight.skills.Skill;
import com.epicfight.skills.SkillContainer;
import com.epicfight.skills.SkillContainerSpecialAttack;
import com.epicfight.utils.game.IExtendedDamageSource;
import java.util.List;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class EntitydataPlayer<T extends EntityPlayer>
extends EntitydataFighter<T> {
    protected float yaw;
    protected SkillContainer[] skills;
    public PlayerClass playerClass;

    @Override
    public void init() {
        super.init();
        this.skills = new SkillContainer[6];
        this.skills[0] = new SkillContainer();
        this.skills[1] = new SkillContainer();
        this.skills[2] = new SkillContainer();
        this.skills[3] = new SkillContainer();
        this.skills[4] = new SkillContainer();
        this.skills[5] = new SkillContainerSpecialAttack();
        this.setPlayerClass(Classes.GENERAL);
    }

    @Override
    public void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(AnimatorClient.LivingMotion.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.WALKING, Animations.BIPED_WALK);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.RUNNING, Animations.BIPED_RUN);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.FLYING, Animations.BIPED_FLYING);
        animator.addLivingAnimation(AnimatorClient.LivingMotion.DEATH, Animations.BIPED_DEATH);
        animator.setCurrentLivingMotionsToDefault();
    }

    public void setPlayerClass(PlayerClass playerClass) {
        this.playerClass = playerClass;
        List<Skill> skillset = this.playerClass.getSkillSet();
        for (int i = 0; i < skillset.size(); ++i) {
            this.skills[i].setSkill(skillset.get(i));
        }
    }

    public void resetSkillCost(int index) {
        this.skills[index].reset();
    }

    public void setSkillCost(float amount, int index) {
        this.skills[index].setRestricValue(amount);
    }

    public void changeYaw(float amount) {
        this.yaw = amount;
    }

    public SkillContainer getSkill(int slot) {
        return this.skills[slot];
    }

    public SkillContainer getSkill(Skill.SkillSlot slot) {
        return this.skills[slot.getIndex()];
    }

    @Override
    public void update() {
        float penalizedTick = this.getWeightPaneltyDivider();
        for (SkillContainer skill : this.skills) {
            skill.update(penalizedTick);
        }
        super.update();
    }

    public float getWeightPaneltyMultiplier() {
        if (this.getWeight() > (double)this.playerClass.weightPanelty) {
            return (float)(this.getWeight() / (double)this.playerClass.weightPanelty);
        }
        return 0.0f;
    }

    public float getWeightPaneltyDivider() {
        return (float)((double)this.playerClass.weightPanelty / this.getWeight());
    }

    public float getAttackSpeed() {
        return (float)((EntityPlayer)this.orgEntity).func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e();
    }

    @Override
    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType) {
        return IExtendedDamageSource.causePlayerDamage((EntityPlayer)this.orgEntity, stunType);
    }

    public void discard() {
        super.aboutToDeath();
    }

    @Override
    public Model getEntityModel() {
        return this.isRemote() ? Models.CLIENT.ENTITY_PLAYER : Models.SERVER.ENTITY_PLAYER;
    }

    public void resetSize(float width, float height) {
        float f = ((EntityPlayer)this.orgEntity).field_70130_N;
        ((EntityPlayer)this.orgEntity).field_70130_N = width;
        ((EntityPlayer)this.orgEntity).field_70131_O = height;
        if (((EntityPlayer)this.orgEntity).field_70130_N < f) {
            double d0 = (double)width * 0.5;
            ((EntityPlayer)this.orgEntity).func_174826_a(new AxisAlignedBB(((EntityPlayer)this.orgEntity).field_70165_t - d0, ((EntityPlayer)this.orgEntity).field_70163_u, ((EntityPlayer)this.orgEntity).field_70161_v - d0, ((EntityPlayer)this.orgEntity).field_70165_t + d0, ((EntityPlayer)this.orgEntity).field_70163_u + (double)((EntityPlayer)this.orgEntity).field_70131_O, ((EntityPlayer)this.orgEntity).field_70161_v + d0));
            return;
        }
        AxisAlignedBB axisalignedbb = ((EntityPlayer)this.orgEntity).func_174813_aQ();
        ((EntityPlayer)this.orgEntity).func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)((EntityPlayer)this.orgEntity).field_70130_N, axisalignedbb.field_72338_b + (double)((EntityPlayer)this.orgEntity).field_70131_O, axisalignedbb.field_72339_c + (double)((EntityPlayer)this.orgEntity).field_70130_N));
        if (((EntityPlayer)this.orgEntity).field_70130_N > f && !((EntityPlayer)this.orgEntity).field_70170_p.field_72995_K) {
            ((EntityPlayer)this.orgEntity).func_70091_d(MoverType.SELF, (double)(f - ((EntityPlayer)this.orgEntity).field_70130_N), 0.0, (double)(f - ((EntityPlayer)this.orgEntity).field_70130_N));
        }
    }
}

