/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.item;

import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.gamedata.Models;
import com.epicfight.model.Model;
import java.util.UUID;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorCapability
extends CapabilityItem {
    protected static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    @SideOnly(value=Side.CLIENT)
    protected Model equipModel;
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation equipTexture;

    public ArmorCapability(Model equipModel, ResourceLocation equipTexture) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.equipModel = equipModel;
            this.equipTexture = equipTexture;
        }
    }

    public Model getEquipModel(EntityEquipmentSlot slot, boolean smallsize) {
        return this.equipModel;
    }

    public static Model getBipedArmorModel(EntityEquipmentSlot slot, boolean isBaby) {
        switch (slot) {
            case HEAD: {
                return isBaby ? Models.CLIENT.ITEM_HELMET_BABYSIZE : Models.CLIENT.ITEM_HELMET;
            }
            case CHEST: {
                return isBaby ? Models.CLIENT.ITEM_CHESTPLATE_BABYSIZE : Models.CLIENT.ITEM_CHESTPLATE;
            }
            case LEGS: {
                return isBaby ? Models.CLIENT.ITEM_LEGGINS_BABYSIZE : Models.CLIENT.ITEM_LEGGINS;
            }
            case FEET: {
                return isBaby ? Models.CLIENT.ITEM_BOOTS_BABYSIZE : Models.CLIENT.ITEM_BOOTS;
            }
        }
        return null;
    }
}

