/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.item;

import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Colliders;
import com.epicfight.gamedata.Sounds;
import com.epicfight.physics.Collider;
import com.epicfight.skills.Skill;
import com.epicfight.utils.game.DamageAttributes;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CapabilityItem {
    protected static List<StaticAnimation> commonAutoAttackMotion = new ArrayList<StaticAnimation>();
    protected DamageAttributes oneHandedStyleDamageAttribute;
    protected DamageAttributes twoHandedStyleDamageAttribute;

    public static List<StaticAnimation> getBasicAutoAttackMotion() {
        return commonAutoAttackMotion;
    }

    protected void loadClientThings() {
    }

    public CapabilityItem() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.loadClientThings();
        }
        this.oneHandedStyleDamageAttribute = new DamageAttributes();
        this.registerAttribute();
    }

    public CapabilityItem(Item.ToolMaterial material) {
        this.oneHandedStyleDamageAttribute = new DamageAttributes();
    }

    protected void registerAttribute() {
    }

    public void modifyItemTooltip(List<String> itemTooltip, boolean isOffhandEmpty) {
        if (this.isTwoHanded()) {
            itemTooltip.add(1, TextFormatting.DARK_GRAY + "Twohanded");
        } else if (!this.canUsedOffhand()) {
            itemTooltip.add(1, TextFormatting.DARK_GRAY + "Mainhand Only");
        }
        DamageAttributes attribute = this.getDamageAttributesInCondition(isOffhandEmpty);
        if (attribute != null) {
            for (IAttributeInstance attr : attribute.getAttributeMap().func_111146_a()) {
                if (attr.func_111126_e() == 0.0) continue;
                itemTooltip.add(" " + String.format(attr.func_111123_a().func_111108_a(), attr.func_111126_e()));
            }
        }
    }

    public List<StaticAnimation> getAutoAttckMotion(boolean offHandEmpty) {
        return CapabilityItem.getBasicAutoAttackMotion();
    }

    public StaticAnimation getMountAttackMotion() {
        return null;
    }

    public boolean hasSpecialAttack() {
        return false;
    }

    public Skill getSpecialAttack() {
        return null;
    }

    public SoundEvent getSmashingSound() {
        return Sounds.WHOOSH;
    }

    public SoundEvent getHitSound() {
        return Sounds.BLUNT_HIT;
    }

    public Collider getWeaponCollider() {
        return Colliders.fist;
    }

    public DamageAttributes getDamageAttributesInCondition(boolean offhandEmtpy) {
        return this.isTwoHanded() || !this.canUsedOffhand() && offhandEmtpy ? this.twoHandedStyleDamageAttribute : this.oneHandedStyleDamageAttribute;
    }

    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    @SideOnly(value=Side.CLIENT)
    public Map<AnimatorClient.LivingMotion, StaticAnimation> getLivingMotionChanges() {
        return null;
    }

    public boolean canUsedOffhand() {
        return !this.isTwoHanded();
    }

    public boolean isTwoHanded() {
        return false;
    }

    static {
        commonAutoAttackMotion.add(Animations.FIST_AUTO_1);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_2);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_3);
        commonAutoAttackMotion.add(Animations.FIST_DASH);
    }
}

