/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.item;

import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.physics.Collider;
import com.epicfight.skills.SkillAttack;
import com.epicfight.utils.game.DamageAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModWeaponCapability
extends CapabilityItem {
    private final SkillAttack specialAttack;
    private final SoundEvent smashingSound;
    private final SoundEvent hitSound;
    private final StaticAnimation mountAttackMotion;
    private final Collider weaponCollider;
    private final boolean twoHanded;
    private final boolean mainHandOnly;
    private List<StaticAnimation> autoAttackMotions;
    private List<StaticAnimation> autoAttackTwohandMotions;
    @SideOnly(value=Side.CLIENT)
    private Map<AnimatorClient.LivingMotion, StaticAnimation> livingMotionChangers;

    public ModWeaponCapability(SkillAttack specialAttack, SoundEvent smash, SoundEvent hit, Collider weaponCollider, double armorIgnorance, double impact, int hitEnemiesAtOnce, boolean twoHanded, boolean mainHandOnly, StaticAnimation mountAttackMotion) {
        this.specialAttack = specialAttack;
        this.smashingSound = smash;
        this.hitSound = hit;
        this.twoHanded = twoHanded;
        this.mainHandOnly = mainHandOnly;
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.DEFENCE_IGNORE, armorIgnorance);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, impact);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, hitEnemiesAtOnce);
        this.mountAttackMotion = mountAttackMotion;
        this.weaponCollider = weaponCollider;
    }

    @SideOnly(value=Side.CLIENT)
    public void addLivingMotionChanger(AnimatorClient.LivingMotion livingMotion, StaticAnimation animation) {
        if (this.livingMotionChangers == null) {
            this.livingMotionChangers = new HashMap<AnimatorClient.LivingMotion, StaticAnimation>();
        }
        this.livingMotionChangers.put(livingMotion, animation);
    }

    public void addAutoAttackCombos(StaticAnimation animation) {
        if (this.autoAttackMotions == null) {
            this.autoAttackMotions = new ArrayList<StaticAnimation>();
        }
        this.autoAttackMotions.add(animation);
    }

    public void addTwohandAutoAttackCombos(StaticAnimation animation) {
        if (this.autoAttackTwohandMotions == null) {
            this.autoAttackTwohandMotions = new ArrayList<StaticAnimation>();
        }
        this.autoAttackTwohandMotions.add(animation);
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(boolean offHandEmpty) {
        return this.autoAttackMotions != null || this.autoAttackTwohandMotions != null ? (this.twoHanded || !this.canUsedOffhand() && offHandEmpty ? this.autoAttackTwohandMotions : this.autoAttackMotions) : super.getAutoAttckMotion(offHandEmpty);
    }

    @Override
    public StaticAnimation getMountAttackMotion() {
        return this.mountAttackMotion;
    }

    @Override
    public boolean hasSpecialAttack() {
        return this.specialAttack != null;
    }

    @Override
    public SkillAttack getSpecialAttack() {
        return this.specialAttack;
    }

    @Override
    public SoundEvent getSmashingSound() {
        return this.smashingSound;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.hitSound;
    }

    @Override
    public Collider getWeaponCollider() {
        return this.weaponCollider != null ? this.weaponCollider : super.getWeaponCollider();
    }

    @Override
    public boolean canUsedOffhand() {
        return this.twoHanded ? false : !this.mainHandOnly;
    }

    public void setTwoHandStyleAttribute(double armorIgnorance, double impact, int hitEnemiesAtOnce) {
        this.twoHandedStyleDamageAttribute = new DamageAttributes();
        this.twoHandedStyleDamageAttribute.addAttribute(DamageAttributes.DEFENCE_IGNORE, armorIgnorance);
        this.twoHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, impact);
        this.twoHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, hitEnemiesAtOnce);
    }

    @Override
    public boolean isTwoHanded() {
        return this.twoHanded;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Map<AnimatorClient.LivingMotion, StaticAnimation> getLivingMotionChanges() {
        return this.livingMotionChangers;
    }
}

