/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.item;

import com.epicfight.capabilities.item.ArmorCapability;
import com.epicfight.gamedata.Models;
import com.epicfight.model.Model;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.text.TextFormatting;

public class VanillaArmorCapability
extends ArmorCapability {
    private final EntityEquipmentSlot armorType;
    private final float weight;

    public VanillaArmorCapability(ItemArmor item) {
        super(null, null);
        this.armorType = item.field_77881_a;
        switch (item.func_82812_d()) {
            case LEATHER: {
                this.weight = item.field_77879_b;
                break;
            }
            case GOLD: {
                this.weight = (float)item.field_77879_b * 2.5f;
                break;
            }
            case CHAIN: {
                this.weight = (float)item.field_77879_b * 2.5f;
                break;
            }
            case IRON: {
                this.weight = (float)item.field_77879_b * 3.0f;
                break;
            }
            case DIAMOND: {
                this.weight = (float)item.field_77879_b * 3.0f;
                break;
            }
            default: {
                this.weight = 0.0f;
            }
        }
    }

    @Override
    public void modifyItemTooltip(List<String> itemTooltip, boolean isOffhandEmpty) {
        itemTooltip.add(1, TextFormatting.BLUE + " +" + (int)this.weight + " Weight");
    }

    @Override
    public Model getEquipModel(EntityEquipmentSlot slot, boolean smallsize) {
        switch (slot) {
            case HEAD: {
                return smallsize ? Models.CLIENT.ITEM_HELMET_BABYSIZE : Models.CLIENT.ITEM_HELMET;
            }
            case CHEST: {
                return smallsize ? Models.CLIENT.ITEM_CHESTPLATE_BABYSIZE : Models.CLIENT.ITEM_CHESTPLATE;
            }
            case LEGS: {
                return smallsize ? Models.CLIENT.ITEM_LEGGINS_BABYSIZE : Models.CLIENT.ITEM_LEGGINS;
            }
            case FEET: {
                return smallsize ? Models.CLIENT.ITEM_BOOTS_BABYSIZE : Models.CLIENT.ITEM_BOOTS;
            }
        }
        return null;
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot equipmentSlot) {
        Multimap<String, AttributeModifier> attributes = super.getItemAttributeModifiers(equipmentSlot);
        if (equipmentSlot == this.armorType) {
            attributes.put((Object)"weight", (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.weight, 0).func_111168_a(false));
        }
        return attributes;
    }
}

