/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.item;

import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.item.MaterialItemCapability;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Colliders;
import com.epicfight.gamedata.Skills;
import com.epicfight.gamedata.Sounds;
import com.epicfight.physics.Collider;
import com.epicfight.skills.Skill;
import com.epicfight.utils.game.DamageAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;

public class VanillaAxeCapability
extends MaterialItemCapability {
    private static List<StaticAnimation> axeAttackMotions = new ArrayList<StaticAnimation>();
    private Skill specialAttack;

    public VanillaAxeCapability(Item.ToolMaterial toolMatarial) {
        super(toolMatarial);
        this.specialAttack = toolMatarial == Item.ToolMaterial.WOOD ? null : Skills.GUILLOTINE_AXE;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(boolean offHandEmpty) {
        return axeAttackMotions;
    }

    @Override
    public boolean hasSpecialAttack() {
        return this.material.func_77996_d() != 0;
    }

    @Override
    public Skill getSpecialAttack() {
        return this.specialAttack;
    }

    @Override
    protected void registerAttribute() {
        int i = this.material.func_77996_d();
        if (i != 0) {
            this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.DEFENCE_IGNORE, 10.0 * (double)i);
        }
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, 1.0);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, 3.0);
    }

    @Override
    public SoundEvent getHitSound() {
        return Sounds.BLADE_HIT;
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.tools;
    }

    static {
        axeAttackMotions = new ArrayList<StaticAnimation>();
        axeAttackMotions.add(Animations.SWORD_AUTO_3);
        axeAttackMotions.add(Animations.SWORD_AUTO_4);
        axeAttackMotions.add(Animations.AXE_DASH);
    }
}

