/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.capabilities.item;

import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.item.MaterialItemCapability;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Colliders;
import com.epicfight.gamedata.Skills;
import com.epicfight.gamedata.Sounds;
import com.epicfight.physics.Collider;
import com.epicfight.skills.Skill;
import com.epicfight.utils.game.DamageAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;

public class VanillaSwordCapability
extends MaterialItemCapability {
    private static List<StaticAnimation> swordAttackMotion = new ArrayList<StaticAnimation>();
    private Skill specialAttack;
    private SoundEvent hitSound;

    public VanillaSwordCapability(Item.ToolMaterial toolMatarial) {
        super(toolMatarial);
        this.specialAttack = toolMatarial == Item.ToolMaterial.WOOD ? null : Skills.SWEEPING_EDGE;
        this.hitSound = toolMatarial == Item.ToolMaterial.WOOD ? Sounds.BLUNT_HIT : Sounds.BLADE_HIT;
    }

    @Override
    protected void registerAttribute() {
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.IMPACT, 0.0);
        this.oneHandedStyleDamageAttribute.addAttribute(DamageAttributes.MULTIPLE_HIT, 2.0);
    }

    @Override
    public boolean hasSpecialAttack() {
        return this.material.func_77996_d() != 0;
    }

    @Override
    public Skill getSpecialAttack() {
        return this.specialAttack;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(boolean offHandEmpty) {
        return swordAttackMotion;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.hitSound;
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.sword;
    }

    static {
        swordAttackMotion = new ArrayList<StaticAnimation>();
        swordAttackMotion.add(Animations.SWORD_AUTO_1);
        swordAttackMotion.add(Animations.SWORD_AUTO_2);
        swordAttackMotion.add(Animations.SWORD_AUTO_3);
        swordAttackMotion.add(Animations.SWORD_AUTO_4);
        swordAttackMotion.add(Animations.SWORD_DASH);
    }
}

