/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.animation;

import com.epicfight.animation.Animator;
import com.epicfight.animation.Joint;
import com.epicfight.animation.Pose;
import com.epicfight.animation.types.DynamicAnimation;
import com.epicfight.animation.types.MirrorAnimation;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.client.animation.BaseLayer;
import com.epicfight.client.animation.MixLayer;
import com.epicfight.gamedata.Animations;
import com.epicfight.main.ModCore;
import com.epicfight.utils.math.Mat4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimatorClient
extends Animator {
    private final Map<LivingMotion, StaticAnimation> livingAnimations = new HashMap<LivingMotion, StaticAnimation>();
    private Map<LivingMotion, StaticAnimation> defaultLivingAnimations;
    private Map<LivingMotion, StaticAnimation> livingMixAnimations;
    private List<LivingMotion> modifiedLivingMotions;
    public final BaseLayer baseLayer;
    public final MixLayer mixLayer;
    private LivingMotion currentMotion;
    private LivingMotion currentMixMotion;
    public boolean reversePlay = false;
    public boolean mixLayerActivated = false;

    public AnimatorClient(EntitydataLiving entitydata) {
        this.entitydata = entitydata;
        this.baseLayer = new BaseLayer(Animations.DUMMY_ANIMATION);
        this.mixLayer = new MixLayer(Animations.DUMMY_ANIMATION);
        this.currentMotion = LivingMotion.IDLE;
        if (entitydata instanceof EntitydataPlayer) {
            this.defaultLivingAnimations = new HashMap<LivingMotion, StaticAnimation>();
            this.modifiedLivingMotions = new ArrayList<LivingMotion>();
        }
    }

    @Override
    public void playAnimation(int id, float modifyTime) {
        this.playAnimation(Animations.findAnimationDataById(id), modifyTime);
    }

    @Override
    public void playAnimation(StaticAnimation nextAnimation, float modifyTime) {
        this.baseLayer.pause = false;
        this.mixLayer.pause = false;
        this.reversePlay = false;
        if (modifyTime < 0.0f) {
            this.baseLayer.playAnimation(nextAnimation, this.entitydata);
        } else {
            this.baseLayer.playAnimation(nextAnimation, this.entitydata, modifyTime);
        }
    }

    @Override
    public void vacateCurrentPlay() {
        this.baseLayer.animationPlayer.setPlayAnimation(Animations.DUMMY_ANIMATION);
    }

    public void addLivingAnimation(LivingMotion motion, StaticAnimation animation) {
        this.livingAnimations.put(motion, animation);
        if (motion == this.currentMotion && !this.entitydata.isInaction()) {
            this.playAnimation(animation, 0.0f);
        }
    }

    public void addLivingMixAnimation(LivingMotion motion, StaticAnimation animation) {
        if (this.livingMixAnimations == null) {
            this.livingMixAnimations = new HashMap<LivingMotion, StaticAnimation>();
        }
        this.livingMixAnimations.put(motion, animation);
        if (motion == this.currentMotion && !this.entitydata.isInaction()) {
            if (animation instanceof MirrorAnimation) {
                this.playMixLayerAnimation(((MirrorAnimation)animation).checkHandAndReturnAnimation(this.entitydata.getOriginalEntity().func_184600_cs()), "Thigh_L", "Thigh_R");
            } else {
                this.playMixLayerAnimation(animation, "Thigh_L", "Thigh_R");
            }
        }
    }

    public void addModifiedLivingMotion(LivingMotion motion, StaticAnimation animation) {
        if (!this.modifiedLivingMotions.contains((Object)motion)) {
            this.modifiedLivingMotions.add(motion);
        }
        this.addLivingAnimation(motion, animation);
    }

    public void resetModifiedLivingMotions() {
        if (this.modifiedLivingMotions.size() > 0) {
            for (LivingMotion livingMotion : this.modifiedLivingMotions) {
                this.addLivingAnimation(livingMotion, this.defaultLivingAnimations.get((Object)livingMotion));
            }
            this.modifiedLivingMotions.clear();
        }
    }

    public void setCurrentLivingMotionsToDefault() {
        this.defaultLivingAnimations.clear();
        this.defaultLivingAnimations.putAll(this.livingAnimations);
    }

    public void playLoopMotion() {
        this.currentMotion = this.entitydata.currentMotion;
        this.baseLayer.playAnimation(this.livingAnimations.get((Object)this.entitydata.currentMotion), this.entitydata, 0.0f);
    }

    public void playMixLoopMotion() {
        if (this.currentMixMotion == LivingMotion.AIMING && this.entitydata.currentMixMotion == LivingMotion.NONE) {
            this.playMixLayerAnimation(Animations.BIPED_BOW_SHOT, "Thigh_L", "Thigh_R");
            this.entitydata.resetLivingMixLoop();
        } else if (this.entitydata.currentMixMotion == LivingMotion.NONE) {
            this.offMixLayer();
        } else {
            StaticAnimation animation = this.livingMixAnimations.get((Object)this.entitydata.currentMixMotion);
            if (animation instanceof MirrorAnimation) {
                this.playMixLayerAnimation(((MirrorAnimation)animation).checkHandAndReturnAnimation(this.entitydata.getOriginalEntity().func_184600_cs()), "Thigh_L", "Thigh_R");
            } else {
                this.playMixLayerAnimation(animation, "Thigh_L", "Thigh_R");
            }
        }
        this.mixLayer.pause = false;
        this.currentMixMotion = this.entitydata.currentMixMotion;
    }

    public void playMixLayerAnimation(int id, String ... maskedJoints) {
        this.playMixLayerAnimation(Animations.findAnimationDataById(id), maskedJoints);
    }

    public void playMixLayerAnimation(StaticAnimation nextAnimation, String ... maskedJoints) {
        if (!this.mixLayerActivated) {
            this.mixLayerActivated = true;
            this.mixLayer.animationPlayer.synchronize(this.baseLayer.animationPlayer);
        }
        this.mixLayer.linkEndPhase = false;
        this.mixLayer.setPlayAnimationWithJointMask(nextAnimation, this.entitydata, 0.0f, maskedJoints);
    }

    public void offMixLayer() {
        if (this.mixLayerActivated) {
            this.mixLayer.linkEndPhase = true;
            this.mixLayer.setMixLinkAnimation(this.entitydata, 0.0f);
            this.mixLayer.playAnimation(this.mixLayer.mixLinkAnimation, this.entitydata);
            this.mixLayer.nextPlaying = null;
            this.mixLayer.pause = false;
        }
    }

    public void disableMixLayer() {
        this.mixLayerActivated = false;
        if (this.mixLayer.animationPlayer.getPlay() != null) {
            this.mixLayer.animationPlayer.getPlay().onFinish(this.entitydata, true);
            this.mixLayer.animationPlayer.setEmpty();
        }
        this.mixLayer.animationPlayer.resetPlayer();
    }

    public void setPoseToModel() {
        if (this.mixLayerActivated) {
            this.applyPoseToJoint(this.getCurrentPose(this.baseLayer), this.getCurrentPose(this.mixLayer), this.entitydata.getEntityModel().getArmature().getJointHierarcy());
        } else {
            this.applyPoseToJoint(this.getCurrentPose(this.baseLayer), this.entitydata.getEntityModel().getArmature().getJointHierarcy(), new Mat4f());
        }
    }

    private void applyPoseToJoint(Pose base, Pose mix, Joint rootJoint) {
        Mat4f currentLocalTransformBase = base.getTransformByName(rootJoint.getName()).toTransformMatrix();
        Mat4f.mul(rootJoint.getLocalTrasnform(), currentLocalTransformBase, currentLocalTransformBase);
        Mat4f bindTransformBase = Mat4f.mul(new Mat4f(), currentLocalTransformBase, null);
        Mat4f currentLocalTransformMix = mix.getTransformByName(rootJoint.getName()).toTransformMatrix();
        Mat4f.mul(rootJoint.getLocalTrasnform(), currentLocalTransformMix, currentLocalTransformMix);
        Mat4f bindTransformMix = Mat4f.mul(new Mat4f(), currentLocalTransformMix, null);
        bindTransformMix.m31 = bindTransformBase.m31;
        for (Joint joints : rootJoint.getSubJoints()) {
            if (this.mixLayer.jointMasked(joints.getName())) {
                this.applyPoseToJoint(base, joints, bindTransformBase);
                continue;
            }
            this.applyPoseToJoint(mix, joints, bindTransformMix);
        }
    }

    private void applyPoseToJoint(Pose pose, Joint joint, Mat4f parentTransform) {
        Mat4f currentLocalTransform = pose.getTransformByName(joint.getName()).toTransformMatrix();
        Mat4f.mul(joint.getLocalTrasnform(), currentLocalTransform, currentLocalTransform);
        Mat4f bindTransform = Mat4f.mul(parentTransform, currentLocalTransform, null);
        Mat4f.mul(bindTransform, joint.getAnimatedTransform(), bindTransform);
        joint.setAnimatedTransform(bindTransform);
        for (Joint joints : joint.getSubJoints()) {
            this.applyPoseToJoint(pose, joints, bindTransform);
        }
    }

    @Override
    public void update() {
        if (this.pause) {
            return;
        }
        this.baseLayer.update(this.entitydata, this.reversePlay);
        if (this.baseLayer.animationPlayer.isEnd() && this.baseLayer.nextPlaying == null) {
            this.playLoopMotion();
        }
        if (this.mixLayerActivated) {
            this.mixLayer.update(this.entitydata, false);
            if (this.mixLayer.animationPlayer.isEnd()) {
                if (this.mixLayer.linkEndPhase) {
                    if (!this.pause && this.mixLayer.nextPlaying == null) {
                        this.disableMixLayer();
                        this.mixLayer.linkEndPhase = false;
                    }
                } else {
                    this.mixLayer.animationPlayer.getPlay().onFinish(this.entitydata, this.mixLayer.animationPlayer.isEnd());
                    if (!this.mixLayer.pause) {
                        this.mixLayer.setMixLinkAnimation(this.entitydata, 0.0f);
                        this.mixLayer.playAnimation(this.mixLayer.mixLinkAnimation, this.entitydata);
                        this.mixLayer.linkEndPhase = true;
                    }
                }
            }
        }
    }

    @Override
    public void playDeathAnimation() {
        this.playAnimation(this.livingAnimations.get((Object)LivingMotion.DEATH), 0.0f);
    }

    public StaticAnimation getDeathAnimation() {
        return this.livingAnimations.get((Object)LivingMotion.DEATH);
    }

    @Override
    public void onEntityDeath() {
        this.baseLayer.clear(this.entitydata);
        this.mixLayer.clear(this.entitydata);
    }

    @Override
    public float getElapsedTime() {
        return this.mixLayerActivated ? this.mixLayer.animationPlayer.getElapsedTime() : this.baseLayer.animationPlayer.getElapsedTime();
    }

    public Pose getCurrentPose(BaseLayer layer) {
        return layer.animationPlayer.getCurrentPose(this.entitydata, this.baseLayer.pause ? 1.0f : ModCore.partialTick);
    }

    public boolean compareMotion(LivingMotion motion) {
        return this.currentMotion == motion;
    }

    public boolean compareMixMotion(LivingMotion motion) {
        return this.currentMixMotion == motion;
    }

    public void resetMotion() {
        this.currentMotion = LivingMotion.IDLE;
    }

    public void resetMixMotion() {
        this.currentMixMotion = LivingMotion.NONE;
    }

    @Override
    public DynamicAnimation getPlayAnimation() {
        return this.mixLayerActivated ? this.mixLayer.animationPlayer.getPlay() : this.baseLayer.animationPlayer.getPlay();
    }

    public static enum LivingMotion {
        IDLE,
        ANGRY,
        FLOATING,
        BENDING,
        WALKING,
        RUNNING,
        SWIMMING,
        FLYING,
        SNEAKING,
        KNEELING,
        FALL,
        MOUNT,
        DEATH,
        CHASING,
        SPELLCASTING,
        NONE,
        AIMING,
        BLOCKING;

    }
}

