/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.animation;

import com.epicfight.animation.AnimationPlayer;
import com.epicfight.animation.Pose;
import com.epicfight.animation.types.DynamicAnimation;
import com.epicfight.animation.types.LinkAnimation;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.main.ModCore;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BaseLayer {
    public final AnimationPlayer animationPlayer;
    protected DynamicAnimation nextPlaying;
    protected LinkAnimation linkAnimation = new LinkAnimation();
    public boolean pause;

    public BaseLayer(DynamicAnimation animation) {
        this.animationPlayer = new AnimationPlayer(animation);
        this.nextPlaying = new StaticAnimation();
    }

    public void playAnimation(DynamicAnimation nextAnimation, EntitydataLiving entitydata, float modifyTime) {
        DynamicAnimation anim1 = this.animationPlayer.getPlay();
        this.animationPlayer.getPlay().onFinish(entitydata, this.animationPlayer.isEnd());
        DynamicAnimation anim2 = this.animationPlayer.getPlay();
        if (anim1.equals(anim2)) {
            nextAnimation.onActivate(entitydata);
            this.setLinkAnimation(nextAnimation, entitydata, modifyTime);
            this.linkAnimation.putOnPlayer(this.animationPlayer);
            this.nextPlaying = nextAnimation;
        }
    }

    public void playAnimation(DynamicAnimation nextAnimation, EntitydataLiving entitydata) {
        this.animationPlayer.getPlay().onFinish(entitydata, this.animationPlayer.isEnd());
        nextAnimation.onActivate(entitydata);
        nextAnimation.putOnPlayer(this.animationPlayer);
        this.nextPlaying = null;
    }

    public void setLinkAnimation(DynamicAnimation nextAnimation, EntitydataLiving entitydata, float timeModifier) {
        Pose currentPose = this.animationPlayer.getCurrentPose(entitydata, ModCore.partialTick);
        nextAnimation.getLinkAnimation(currentPose, timeModifier, entitydata, this.linkAnimation);
    }

    public void update(EntitydataLiving entitydata, boolean reversePlay) {
        if (this.pause) {
            return;
        }
        float frameTime = 0.05f * this.animationPlayer.getPlay().getPlaySpeed(entitydata);
        frameTime = reversePlay ? -frameTime : frameTime;
        this.animationPlayer.update(frameTime);
        this.animationPlayer.getPlay().onUpdate(entitydata);
        if (this.animationPlayer.isEnd() && this.nextPlaying != null) {
            float exceedTime = this.animationPlayer.getExceedTime();
            this.animationPlayer.getPlay().onFinish(entitydata, true);
            this.nextPlaying.putOnPlayer(this.animationPlayer);
            this.animationPlayer.setElapsedTime(exceedTime);
            this.nextPlaying = null;
        }
    }

    public void clear(EntitydataLiving entitydata) {
        if (this.animationPlayer.getPlay() != null) {
            this.animationPlayer.getPlay().onFinish(entitydata, this.animationPlayer.isEnd());
        }
        if (this.nextPlaying != null) {
            this.nextPlaying.onFinish(entitydata, false);
        }
    }
}

