/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.capabilites.entity;

import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Models;
import com.epicfight.main.ModCore;
import com.epicfight.model.Model;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntitydataClientPlayer<T extends AbstractClientPlayer>
extends EntitydataPlayer<T> {
    private ItemStack prevHeldItem;
    private boolean swingArm;

    @Override
    public void init() {
        super.init();
        this.prevHeldItem = ItemStack.field_190927_a;
    }

    @Override
    public void initAnimator(AnimatorClient animator) {
        super.initAnimator(animator);
        animator.addLivingMixAnimation(AnimatorClient.LivingMotion.AIMING, Animations.BIPED_BOW_AIM);
        animator.addLivingMixAnimation(AnimatorClient.LivingMotion.BLOCKING, Animations.BIPED_BLOCK);
    }

    @Override
    public void updateMotion() {
        EnumAction enumaction;
        if (((AbstractClientPlayer)this.orgEntity).func_184613_cA()) {
            this.currentMotion = AnimatorClient.LivingMotion.FLYING;
        } else if (((AbstractClientPlayer)this.orgEntity).func_184218_aH()) {
            this.currentMotion = AnimatorClient.LivingMotion.MOUNT;
        } else {
            AnimatorClient animator = this.getClientAnimator();
            if (((AbstractClientPlayer)this.orgEntity).field_70181_x < (double)-0.55f) {
                this.currentMotion = AnimatorClient.LivingMotion.FALL;
            } else if (((AbstractClientPlayer)this.orgEntity).field_70721_aZ > 0.01f) {
                this.currentMotion = ((AbstractClientPlayer)this.orgEntity).func_70051_ag() ? AnimatorClient.LivingMotion.RUNNING : (((AbstractClientPlayer)this.orgEntity).func_70093_af() ? AnimatorClient.LivingMotion.SNEAKING : AnimatorClient.LivingMotion.WALKING);
                if (((AbstractClientPlayer)this.orgEntity).field_191988_bg > 0.0f) {
                    animator.reversePlay = false;
                } else if (((AbstractClientPlayer)this.orgEntity).field_191988_bg < 0.0f) {
                    animator.reversePlay = true;
                }
            } else {
                animator.reversePlay = false;
                this.currentMotion = ((AbstractClientPlayer)this.orgEntity).func_70093_af() ? AnimatorClient.LivingMotion.KNEELING : AnimatorClient.LivingMotion.IDLE;
            }
        }
        this.currentMixMotion = ((AbstractClientPlayer)this.orgEntity).func_184587_cr() && ((AbstractClientPlayer)this.orgEntity).func_184605_cv() > 0 ? ((enumaction = ((AbstractClientPlayer)this.orgEntity).func_184586_b(((AbstractClientPlayer)this.orgEntity).func_184600_cs()).func_77975_n()) == EnumAction.BLOCK ? AnimatorClient.LivingMotion.BLOCKING : (enumaction == EnumAction.BOW ? AnimatorClient.LivingMotion.AIMING : AnimatorClient.LivingMotion.NONE)) : AnimatorClient.LivingMotion.NONE;
    }

    @Override
    protected void updateOnClient() {
        super.updateOnClient();
        if (((AbstractClientPlayer)this.orgEntity).field_70725_aQ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
        if (this.prevHeldItem.func_77973_b() != ((AbstractClientPlayer)this.orgEntity).field_71071_by.func_70448_g().func_77973_b()) {
            this.onHeldItemChange((CapabilityItem)((AbstractClientPlayer)this.orgEntity).func_184614_ca().getCapability(ModCapabilities.CAPABILITY_ITEM, null));
            this.prevHeldItem = ((AbstractClientPlayer)this.orgEntity).field_71071_by.func_70448_g();
        }
        if (this.swingArm != ((AbstractClientPlayer)this.orgEntity).field_82175_bq) {
            if (!this.swingArm) {
                this.getClientAnimator().playMixLayerAnimation(Animations.BIPED_DIG, "Thigh_L", "Thigh_R");
            } else {
                this.getClientAnimator().offMixLayer();
            }
            this.swingArm = ((AbstractClientPlayer)this.orgEntity).field_82175_bq;
        }
    }

    public void onHeldItemChange(CapabilityItem cap) {
        Map<AnimatorClient.LivingMotion, StaticAnimation> livingmotionChangers;
        this.getClientAnimator().resetModifiedLivingMotions();
        if (cap != null && (livingmotionChangers = cap.getLivingMotionChanges()) != null) {
            AnimatorClient animator = this.getClientAnimator();
            for (AnimatorClient.LivingMotion livingMotion : livingmotionChangers.keySet()) {
                animator.addModifiedLivingMotion(livingMotion, livingmotionChangers.get((Object)livingMotion));
            }
        }
    }

    @Override
    public Model getEntityModel() {
        Models modeldata = this.isRemote() ? Models.CLIENT : Models.SERVER;
        return ((AbstractClientPlayer)this.orgEntity).func_175154_l().equals("slim") ? modeldata.ENTITY_PLAYER_SLIMARM : modeldata.ENTITY_PLAYER;
    }

    @Override
    public Mat4f getHeadMatrix() {
        float yaw;
        AbstractClientPlayer entity = (AbstractClientPlayer)this.getOriginalEntity();
        float partialTick = ModCore.partialTick;
        float pitch = 0.0f;
        float prvePitch = 0.0f;
        if (this.inaction || entity.func_184218_aH()) {
            yaw = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialTick);
            float f1 = MathUtils.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTick);
            yaw = f1 - f;
        }
        if (!((AbstractClientPlayer)this.orgEntity).func_184613_cA()) {
            prvePitch = entity.field_70127_C;
            pitch = entity.field_70125_A;
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prvePitch, pitch, yaw, yaw);
    }

    @Override
    public Mat4f getModelMatrix() {
        float rotyaw;
        float prevRotYaw;
        Object entity = this.getOriginalEntity();
        if (((AbstractClientPlayer)this.orgEntity).func_184613_cA()) {
            Mat4f mat = MathUtils.getModelMatrixIntegrated((float)((EntityLivingBase)entity).field_70142_S, (float)((EntityLivingBase)entity).field_70165_t, (float)((EntityLivingBase)entity).field_70137_T, (float)((EntityLivingBase)entity).field_70163_u, (float)((EntityLivingBase)entity).field_70136_U, (float)((EntityLivingBase)entity).field_70161_v, 0.0f, 0.0f, 0.0f, 0.0f);
            Mat4f.rotate((float)(-Math.toRadians(((EntityLivingBase)entity).field_70761_aq)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            float f = (float)((AbstractClientPlayer)this.orgEntity).func_184599_cB() + Minecraft.func_71410_x().func_184121_ak();
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            Mat4f.rotate((float)Math.toRadians(f1 * (-90.0f - ((AbstractClientPlayer)this.orgEntity).field_70125_A)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
            Vec3d vec3d = ((AbstractClientPlayer)this.orgEntity).func_70676_i(Minecraft.func_71410_x().func_184121_ak());
            double d0 = ((AbstractClientPlayer)this.orgEntity).field_70159_w * ((AbstractClientPlayer)this.orgEntity).field_70159_w + ((AbstractClientPlayer)this.orgEntity).field_70179_y * ((AbstractClientPlayer)this.orgEntity).field_70179_y;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (((AbstractClientPlayer)this.orgEntity).field_70159_w * vec3d.field_72450_a + ((AbstractClientPlayer)this.orgEntity).field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = ((AbstractClientPlayer)this.orgEntity).field_70159_w * vec3d.field_72449_c - ((AbstractClientPlayer)this.orgEntity).field_70179_y * vec3d.field_72450_a;
                Mat4f.rotate((float)Math.toRadians((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            }
            return mat;
        }
        float prevPitch = 0.0f;
        float pitch = 0.0f;
        if (((AbstractClientPlayer)this.orgEntity).func_184218_aH()) {
            float yaw = 0.0f;
            if (((AbstractClientPlayer)this.orgEntity).func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase ridingEntity = (EntityLivingBase)((AbstractClientPlayer)this.orgEntity).func_184187_bx();
                prevRotYaw = ridingEntity.field_70760_ar;
                rotyaw = ridingEntity.field_70761_aq;
            } else {
                prevRotYaw = entity.func_184187_bx().field_70126_B;
                rotyaw = entity.func_184187_bx().field_70177_z;
            }
        } else {
            float yaw = this.inaction ? this.yaw : 0.0f;
            prevRotYaw = (this.inaction ? ((EntityLivingBase)entity).field_70177_z : ((EntityLivingBase)entity).field_70760_ar) + yaw;
            rotyaw = (this.inaction ? ((EntityLivingBase)entity).field_70177_z : ((EntityLivingBase)entity).field_70761_aq) + yaw;
        }
        return MathUtils.getModelMatrixIntegrated((float)((EntityLivingBase)entity).field_70142_S, (float)((EntityLivingBase)entity).field_70165_t, (float)((EntityLivingBase)entity).field_70137_T, (float)((EntityLivingBase)entity).field_70163_u, (float)((EntityLivingBase)entity).field_70136_U, (float)((EntityLivingBase)entity).field_70161_v, prevPitch, pitch, prevRotYaw, rotyaw);
    }
}

