/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.events;

import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.epicfight.client.gui.GuiHealthBar;
import com.epicfight.client.gui.GuiSkillBar;
import com.epicfight.client.input.KeyBindings;
import com.epicfight.client.renderer.ModRenderManager;
import com.epicfight.client.renderer.debug.RenderAimHelper;
import com.epicfight.client.renderer.debug.RenderLine;
import com.epicfight.client.renderer.debug.RenderOBB;
import com.epicfight.main.ModCore;
import com.epicfight.physics.Collider;
import com.epicfight.physics.ColliderLine;
import com.epicfight.physics.ColliderOBB;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec3f;
import com.epicfight.utils.math.Vec4f;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderEvents {
    public static RenderLine linerender;
    public static RenderOBB obb;
    @Deprecated
    public static Collider wantToDraw;
    public static RenderAimHelper aimHelper;
    public static GuiSkillBar guiSkillBar;
    public static GuiHealthBar entityHealthbarRenderer;
    private static final Vec3f cameraCorrection;
    private static boolean aiming;
    private static int zoomOutTimer;
    private static int zoomCount;
    private static int zoomMaxCount;
    public static final ResourceLocation nullTexture;

    public static void initRenderers() {
        linerender = new RenderLine(Minecraft.func_71410_x().func_110442_L());
        obb = new RenderOBB(Minecraft.func_71410_x().func_110442_L());
        aimHelper = new RenderAimHelper(Minecraft.func_71410_x().func_110442_L());
    }

    public static void zoomIn() {
        RenderEvents.cameraCorrection.x = -1.5f;
        aiming = true;
        zoomCount = zoomCount == 0 ? 1 : zoomCount;
        zoomOutTimer = 0;
    }

    public static void zoomOut(int timer) {
        aiming = false;
        zoomOutTimer = timer;
    }

    public static boolean isScreenZoomIn() {
        return aiming;
    }

    @SubscribeEvent
    public static void renderLivingEvent(RenderLivingEvent.Pre event) {
        ModRenderManager mr = ModCore.renderManager;
        if (mr.isEntityContained((Entity)event.getEntity())) {
            if (!Minecraft.func_71410_x().func_175598_ae().func_178627_a()) {
                return;
            }
            EntitydataLiving entitydata = (EntitydataLiving)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
            if (entitydata != null && entitydata.getOriginalEntity() != null) {
                event.setCanceled(true);
                mr.renderEntityArmatureModel(entitydata);
            }
        }
        Minecraft.func_71410_x();
        if (Minecraft.func_71382_s()) {
            entityHealthbarRenderer.renderMobHealthBar(event.getEntity());
        }
        if (wantToDraw != null) {
            if (wantToDraw instanceof ColliderOBB) {
                obb.doRender(ModCore.graphicUtils, (ColliderOBB)wantToDraw);
            } else if (wantToDraw instanceof ColliderLine) {
                linerender.doRender(ModCore.graphicUtils, (ColliderLine)wantToDraw);
            }
        }
    }

    @SubscribeEvent
    public static void itemTooltip(ItemTooltipEvent event) {
        block3: {
            CapabilityItem cap;
            block4: {
                if (event.getEntityPlayer() == null || (cap = (CapabilityItem)event.getItemStack().getCapability(ModCapabilities.CAPABILITY_ITEM, null)) == null) break block3;
                if (!KeyBindings.keySpecialAttackTooltip.func_151470_d()) break block4;
                if (cap.getSpecialAttack() == null) break block3;
                event.getToolTip().clear();
                for (String s : cap.getSpecialAttack().getTooltip()) {
                    event.getToolTip().add(s);
                }
                break block3;
            }
            List tooltip = event.getToolTip();
            cap.modifyItemTooltip(event.getToolTip(), event.getEntityPlayer().func_184592_cb().func_190926_b());
            for (int i = 0; i < tooltip.size(); ++i) {
                if (!((String)tooltip.get(i)).contains("Attack Speed")) continue;
                EntitydataPlayerSP entityCap = (EntitydataPlayerSP)event.getEntityPlayer().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                float weaponSpeed = (float)((EntityPlayerSP)entityCap.getOriginalEntity()).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                for (AttributeModifier modifier : event.getItemStack().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                    weaponSpeed += (float)modifier.func_111164_d();
                }
                float attackSpeedPanelty = weaponSpeed * entityCap.getWeightPaneltyMultiplier() * 0.1f;
                tooltip.remove(i);
                tooltip.add(i, String.format(" %.1f Attack Speed", Float.valueOf(weaponSpeed -= attackSpeedPanelty)));
            }
        }
    }

    @SubscribeEvent
    public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
        ModCore.partialTick = (float)event.getRenderPartialTicks();
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MathUtils.view);
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
            RenderEvents.resetupCamera(Minecraft.func_71410_x(), MathUtils.view.get(14), ModCore.partialTick);
            if (zoomCount > 0) {
                if (zoomOutTimer > 0) {
                    --zoomOutTimer;
                } else {
                    zoomCount = aiming ? zoomCount + 1 : zoomCount - 1;
                }
                zoomCount = zoomCount > zoomMaxCount - 1 ? zoomMaxCount : zoomCount;
            }
        }
    }

    @SubscribeEvent
    public static void drawAimHelper(RenderWorldLastEvent event) {
        if (zoomCount > 0 && Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
            aimHelper.doRender(ModCore.graphicUtils);
        }
    }

    private static void resetupCamera(Minecraft minecraft, float prevDistance, float partialTicks) {
        double d3;
        Entity entity = minecraft.func_175606_aa();
        float f = entity.func_70047_e();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)f;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        float intpol = (float)zoomCount / (float)zoomMaxCount;
        Vec3f interpolatedCorrection = new Vec3f(RenderEvents.cameraCorrection.x * intpol, RenderEvents.cameraCorrection.y * intpol, RenderEvents.cameraCorrection.z * intpol);
        Mat4f rotationMatrix = EntitydataPlayerSP.playerdata.getMatrix();
        Vec4f rotateVec = Mat4f.transform(rotationMatrix, new Vec4f(interpolatedCorrection.x, interpolatedCorrection.y, interpolatedCorrection.z - 4.0f, 1.0f), null);
        double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
        double d00 = d0 + (double)rotateVec.x;
        double d11 = d1 - (double)rotateVec.y;
        double d22 = d2 + (double)rotateVec.z;
        for (int i = 0; i < 8; ++i) {
            double d7;
            RayTraceResult raytraceresult;
            float f3 = (i & 1) * 2 - 1;
            float f4 = (i >> 1 & 1) * 2 - 1;
            float f5 = (i >> 2 & 1) * 2 - 1;
            if ((raytraceresult = minecraft.field_71441_e.func_147447_a(new Vec3d(d0 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), new Vec3d(d00 + (double)f3 + (double)f5, d11 + (double)f4, d22 + (double)f5), false, true, false)) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < smallest)) continue;
            smallest = d7;
        }
        float dist = (float)(smallest / d3);
        GlStateManager.func_179109_b((float)(interpolatedCorrection.x * dist), (float)(-interpolatedCorrection.y * dist), (float)(interpolatedCorrection.z * dist));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-prevDistance));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-smallest)));
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MathUtils.view);
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && EntitydataPlayerSP.playerdata != null && !((EntityPlayerSP)EntitydataPlayerSP.playerdata.getOriginalEntity()).func_175149_v() && Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            guiSkillBar.renderGui(EntitydataPlayerSP.playerdata);
        }
    }

    static {
        guiSkillBar = new GuiSkillBar();
        entityHealthbarRenderer = new GuiHealthBar();
        cameraCorrection = new Vec3f(-1.5f, 0.0f, 1.25f);
        zoomOutTimer = 0;
        zoomMaxCount = 20;
        nullTexture = new ResourceLocation("epicfight", "textures/gui/null.png");
    }
}

