/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.gui;

import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.epicfight.client.gui.GuiCombat;
import com.epicfight.skills.Skill;
import com.epicfight.skills.SkillContainer;
import com.epicfight.utils.math.Vec2f;
import com.epicfight.utils.math.Vec3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSkillBar
extends GuiCombat {
    private final int[] flashingTimer = new int[6];
    private final boolean[] flashToggle = new boolean[6];
    private final Map<Skill.SkillSlot, Vec3f> screenPositionMap = new HashMap<Skill.SkillSlot, Vec3f>();
    private static final Vec2f[] vectors = new Vec2f[]{new Vec2f(111.794f, 10.044f), new Vec2f(111.794f, 18.0f), new Vec2f(119.75f, 18.0f), new Vec2f(119.75f, 2.088f), new Vec2f(103.838f, 2.088f), new Vec2f(103.838f, 18.0f)};

    public GuiSkillBar() {
        this.screenPositionMap.put(Skill.SkillSlot.DODGE, new Vec3f(120.0f, 18.0f, 0.0624f));
        this.screenPositionMap.put(Skill.SkillSlot.WEAPON_SPECIAL_ATTACK, new Vec3f(24.0f, 24.0f, 0.078f));
    }

    public void renderGui(EntitydataPlayerSP playerdata) {
        if (((EntityPlayerSP)playerdata.getOriginalEntity()).func_184218_aH()) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int width = sr.func_78326_a();
        int height = sr.func_78328_b();
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BATTLE_ICON);
        this.drawTexturedModalRectDouble(width - 122, height - 28, 10.0, 227.0, 121.0, 28.0);
        for (int i = 0; i < 6; ++i) {
            SkillContainer container = playerdata.getSkill(i);
            if (container.isEmpty()) continue;
            Skill.SkillSlot slot = container.getSkill().getSlot();
            boolean creative = Minecraft.func_71410_x().field_71439_g.func_184812_l_();
            float ratio = creative ? 1.0f : container.getRenderRatio();
            boolean isReady = ratio >= 1.0f || creative;
            int x = (int)this.screenPositionMap.get((Object)((Object)slot)).x;
            int y = (int)this.screenPositionMap.get((Object)((Object)slot)).y;
            float scale = this.screenPositionMap.get((Object)((Object)slot)).z;
            float multiplyScale = 1.0f / scale;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            if (!isReady) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(container.getSkill().getTextureLocation());
            this.func_175174_a((float)(width - x) * multiplyScale, (float)(height - y) * multiplyScale, 0, 0, 255, 255);
            if (this.flashingTimer[i] > 0 && !Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                GlStateManager.func_179144_i((int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.8156863f, (float)((float)this.flashingTimer[i] / 100.0f));
                this.func_175174_a((float)(width - x) * multiplyScale, (float)(height - y) * multiplyScale, 0, 0, 255, 255);
            }
            if (slot != Skill.SkillSlot.WEAPON_SPECIAL_ATTACK) {
                if (!isReady) {
                    int vertexNum = 0;
                    float top = y;
                    float bottom = (float)y - 15.972f;
                    float left = x;
                    float right = (float)x - 15.972f;
                    float middle = (float)x - 7.956f;
                    float lastVertexX = 0.0f;
                    float lastVertexY = 0.0f;
                    if (ratio < 0.125f) {
                        vertexNum = 6;
                        lastVertexX = middle - 7.956f * ratio / 0.125f;
                        lastVertexY = top;
                    } else if (ratio < 0.375f) {
                        vertexNum = 5;
                        lastVertexX = right;
                        lastVertexY = top - 15.972f * (ratio - 0.125f) / 0.25f;
                    } else if (ratio < 0.625f) {
                        vertexNum = 4;
                        lastVertexX = right + 15.972f * (ratio - 0.375f) / 0.25f;
                        lastVertexY = bottom;
                    } else if (ratio < 0.875f) {
                        vertexNum = 3;
                        lastVertexX = left;
                        lastVertexY = bottom + 15.972f * (ratio - 0.625f) / 0.25f;
                    } else {
                        vertexNum = 2;
                        lastVertexX = left - 7.956f * (ratio - 0.875f) / 0.125f;
                        lastVertexY = top;
                    }
                    GlStateManager.func_179144_i((int)0);
                    GlStateManager.func_179131_c((float)0.21f, (float)0.21f, (float)0.21f, (float)0.4f);
                    GL11.glBegin((int)9);
                    for (int j = 0; j < vertexNum; ++j) {
                        GL11.glVertex2d((double)((double)((float)width - GuiSkillBar.vectors[j].x) * 16.02), (double)((double)((float)height - GuiSkillBar.vectors[j].y) * 16.02));
                    }
                    GL11.glVertex2d((double)((double)((float)width - lastVertexX) * 16.02), (double)((double)((float)height - lastVertexY) * 16.02));
                    GL11.glEnd();
                    GL11.glFlush();
                }
            } else if (slot == Skill.SkillSlot.WEAPON_SPECIAL_ATTACK) {
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BATTLE_ICON);
                this.drawTexturedModalRectDouble(width - 102, height - 4, 30.0, 224.0, 75.0f * ratio, 2.0);
            }
            GlStateManager.func_179121_F();
        }
        this.updateFlash();
    }

    private void updateFlash() {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            for (int i = 0; i < this.flashingTimer.length; ++i) {
                if (this.flashingTimer[i] <= 0) continue;
                if (this.flashingTimer[i] > 80) {
                    this.flashToggle[i] = false;
                } else if (this.flashingTimer[i] <= 0) {
                    this.flashToggle[i] = true;
                }
                int n = i;
                this.flashingTimer[n] = this.flashingTimer[n] + (this.flashToggle[i] ? 1 : -1);
            }
        }
    }

    public void notifyFlash(Skill.SkillSlot slot) {
        this.flashingTimer[slot.getIndex()] = 1;
        this.flashToggle[slot.getIndex()] = true;
    }
}

