/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.input;

import com.epicfight.animation.Animator;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.epicfight.network.PacketManager;
import com.epicfight.network.client.CTSExecuteSkill;
import com.epicfight.network.client.CTSPlayAnimation;
import com.epicfight.skills.Skill;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class PlayerController {
    private static Field ispressed = ObfuscationReflectionHelper.findField(KeyBinding.class, (String)"field_151474_i");
    private static GameSettings gameSettings;
    private static KeyBinding[] moveKeys;
    private int comboCounter;
    private int comboHoldCounter;
    private int mouseLeftPressCounter = 0;
    private int shiftPressCounter = 0;
    private boolean mouseLeftPressToggle = false;
    private boolean shiftPressToggle = false;
    private boolean lightPress;
    private EntitydataPlayerSP playerdata;
    private EntityPlayerSP player;

    public static void init() {
        gameSettings = Minecraft.func_71410_x().field_71474_y;
        KeyBinding[] moveKeys = new KeyBinding[]{PlayerController.gameSettings.field_74351_w, PlayerController.gameSettings.field_74368_y, PlayerController.gameSettings.field_74370_x, PlayerController.gameSettings.field_74366_z, PlayerController.gameSettings.field_74314_A, PlayerController.gameSettings.field_74311_E};
        PlayerController.moveKeys = moveKeys;
    }

    public void setPlayerRestart(EntitydataPlayerSP entitydataPlayer) {
        this.comboCounter = 0;
        this.player = (EntityPlayerSP)entitydataPlayer.getOriginalEntity();
        this.playerdata = entitydataPlayer;
        this.mouseLeftPressCounter = 0;
        this.shiftPressCounter = 0;
        this.mouseLeftPressToggle = false;
        this.shiftPressToggle = false;
        this.lightPress = false;
    }

    public void processKey() {
        if (PlayerController.gameSettings.field_74312_F.func_151470_d()) {
            boolean thirPersonView;
            boolean bl = thirPersonView = PlayerController.gameSettings.field_74320_O != 0;
            if (Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && thirPersonView) {
                KeyBinding.func_74510_a((int)PlayerController.gameSettings.field_74312_F.func_151463_i(), (boolean)false);
            }
            if (thirPersonView && this.player.func_184605_cv() == 0) {
                if (this.isKeyPressed(PlayerController.gameSettings.field_74312_F)) {
                    PlayerController.gameSettings.field_74312_F.func_151468_f();
                    if (!this.mouseLeftPressToggle) {
                        this.mouseLeftPressToggle = true;
                    }
                }
            } else if (this.player.func_184825_o(0.0f) < 0.9f) {
                PlayerController.gameSettings.field_74312_F.func_151468_f();
            }
        }
        if (this.mouseLeftPressToggle && !Mouse.isButtonDown((int)(PlayerController.gameSettings.field_74312_F.func_151463_i() + 100))) {
            this.lightPress = true;
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
        }
        while (PlayerController.gameSettings.field_74311_E.func_151468_f()) {
            if (Keyboard.isRepeatEvent() || this.player.func_184218_aH() || Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) continue;
            this.shiftPressToggle = true;
        }
        if (this.isKeyPressed(PlayerController.gameSettings.field_186718_X)) {
            CapabilityItem cap = this.playerdata.getHeldItemCapability(EnumHand.MAIN_HAND);
            if (this.playerdata.isInaction() || cap != null && !cap.canUsedOffhand()) {
                while (PlayerController.gameSettings.field_186718_X.func_151468_f()) {
                }
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.isKeyPressed(PlayerController.gameSettings.field_151456_ac[i])) continue;
            if (this.playerdata.isInaction()) {
                PlayerController.gameSettings.field_151456_ac[i].func_151468_f();
                continue;
            }
            InventoryPlayer inventory = this.player.field_71071_by;
            if (i == inventory.field_70461_c) continue;
            this.resetAttackCounter();
            this.playerdata.cancelUsingItem();
        }
        if (this.shiftPressToggle && !PlayerController.gameSettings.field_74311_E.func_151470_d() && this.playerCanAct() && !this.player.func_70090_H()) {
            if (this.playerdata.getSkill(Skill.SkillSlot.DODGE).canExecute(this.playerdata)) {
                int forward = PlayerController.gameSettings.field_74351_w.func_151470_d() ? 1 : 0;
                int backward = PlayerController.gameSettings.field_74368_y.func_151470_d() ? -1 : 0;
                int left = PlayerController.gameSettings.field_74370_x.func_151470_d() ? 1 : 0;
                int right = PlayerController.gameSettings.field_74366_z.func_151470_d() ? -1 : 0;
                this.playerdata.getSkill(Skill.SkillSlot.DODGE).execute(this.playerdata, forward, backward, left, right);
            }
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
            this.shiftPressToggle = false;
            this.shiftPressCounter = 0;
        }
    }

    public void updateOnPlayerTick() {
        if (this.mouseLeftPressToggle) {
            if (this.mouseLeftPressCounter > 2) {
                if (this.playerCanActSkill()) {
                    CapabilityItem itemCap = this.playerdata.getHeldItemCapability(EnumHand.MAIN_HAND);
                    if (itemCap != null && itemCap.hasSpecialAttack()) {
                        PacketManager.packetHandler.sendToServer((IMessage)new CTSExecuteSkill(Skill.SkillSlot.WEAPON_SPECIAL_ATTACK.getIndex()));
                    }
                    this.mouseLeftPressToggle = false;
                    this.mouseLeftPressCounter = 0;
                    this.resetAttackCounter();
                }
            } else {
                ++this.mouseLeftPressCounter;
            }
        }
        if (this.shiftPressToggle) {
            if (this.shiftPressCounter > 2) {
                if (Keyboard.isKeyDown((int)42)) {
                    KeyBinding.func_74510_a((int)42, (boolean)true);
                }
                this.shiftPressToggle = false;
                this.shiftPressCounter = 0;
            } else {
                KeyBinding.func_74510_a((int)42, (boolean)false);
                ++this.shiftPressCounter;
            }
        }
        if (this.lightPress) {
            if (this.playerCanAct()) {
                float f = this.player.func_184825_o(0.0f);
                if (f >= 1.0f) {
                    this.playAttackMotion(this.player.func_184614_ca(), this.player.func_70051_ag());
                    this.player.func_184821_cY();
                    this.lightPress = false;
                }
            } else if (this.playerdata.getEntityState() == EntitydataLiving.EntityState.ANTIC) {
                this.lightPress = false;
            }
        }
        if (this.comboHoldCounter > 0) {
            float f = this.player.func_184825_o(0.0f);
            if (this.playerdata.getEntityState() == EntitydataLiving.EntityState.FREE && f >= 1.0f) {
                --this.comboHoldCounter;
                if (this.comboHoldCounter == 0) {
                    this.resetAttackCounter();
                }
            }
        }
        if (this.playerdata.isInaction()) {
            this.disableMoveKeys();
            this.player.field_71158_b.field_192832_b = 0.0f;
            this.player.field_71158_b.field_78902_a = 0.0f;
        }
    }

    private void playAttackMotion(ItemStack holdItem, boolean dashAttack) {
        CapabilityItem cap = (CapabilityItem)holdItem.getCapability(ModCapabilities.CAPABILITY_ITEM, null);
        StaticAnimation attackMotion = null;
        if (this.player.func_110317_t()) {
            if (cap != null) {
                attackMotion = cap.getMountAttackMotion();
            }
        } else {
            List<StaticAnimation> combo = null;
            combo = cap != null ? (combo = cap.getAutoAttckMotion(this.player.func_184592_cb().func_190926_b())) : CapabilityItem.getBasicAutoAttackMotion();
            int comboSize = combo.size();
            if (dashAttack) {
                this.comboCounter = comboSize - 1;
            }
            attackMotion = combo.get(this.comboCounter);
            this.comboCounter = dashAttack ? 0 : this.comboCounter + 1;
            this.comboCounter %= comboSize - 1;
            this.comboHoldCounter = 10;
        }
        if (attackMotion != null) {
            ((Animator)this.playerdata.getAnimator()).playAnimation(attackMotion, 0.0f);
            PacketManager.packetHandler.sendToServer((IMessage)new CTSPlayAnimation(attackMotion, 0.0f, false, false));
        }
    }

    public boolean playerCanAct() {
        return !this.player.func_184613_cA() && this.playerdata.currentMotion != AnimatorClient.LivingMotion.FALL && !this.playerdata.isInaction();
    }

    public boolean playerCanActSkill() {
        return !this.player.func_184613_cA() && this.playerdata.currentMotion != AnimatorClient.LivingMotion.FALL && (!this.playerdata.isInaction() || this.playerdata.getEntityState() == EntitydataLiving.EntityState.RECOVERY || this.playerdata.getEntityState() == EntitydataLiving.EntityState.FREE);
    }

    private boolean isKeyPressed(KeyBinding keybinding) {
        int i = 0;
        try {
            i = (Integer)ispressed.get(keybinding);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return i > 0;
    }

    public static void enableMoveKeys() {
        for (KeyBinding key : moveKeys) {
            if (!Keyboard.isKeyDown((int)key.func_151463_i())) continue;
            KeyBinding.func_74510_a((int)key.func_151463_i(), (boolean)true);
            if (key.func_151463_i() != 17) continue;
            Minecraft.func_71410_x().field_71439_g.field_191988_bg = 0.98f;
            Minecraft.func_71410_x().field_71439_g.field_71158_b.field_192832_b = 1.0f;
        }
    }

    private void disableMoveKeys() {
        for (KeyBinding key : moveKeys) {
            KeyBinding.func_74510_a((int)key.func_151463_i(), (boolean)false);
        }
        KeyBinding.func_74510_a((int)PlayerController.gameSettings.field_151444_V.func_151463_i(), (boolean)false);
    }

    public void clear() {
        this.player = null;
        this.playerdata = null;
    }

    public boolean isThirdPerson() {
        return PlayerController.gameSettings.field_74320_O != 0;
    }

    public void resetAttackCounter() {
        this.comboCounter = 0;
    }
}

