/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.opengl;

import com.epicfight.client.opengl.VertexBufferObject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class VertexArrayObject {
    private final int vaoID;
    private final List<VertexBufferObject> vbos = new ArrayList<VertexBufferObject>();
    private VertexBufferObject elementVbo;

    public VertexArrayObject() {
        this.vaoID = GL30.glGenVertexArrays();
    }

    public void bufferDataFloat(int attrib, int size, float[] data) {
        GL30.glBindVertexArray((int)this.vaoID);
        VertexBufferObject vbo = new VertexBufferObject();
        vbo.storeFloatInVbo(attrib, size, data);
        this.vbos.add(vbo);
        GL30.glBindVertexArray((int)0);
    }

    public void bufferDataFloat(int attrib, int size, FloatBuffer data) {
        GL30.glBindVertexArray((int)this.vaoID);
        VertexBufferObject vbo = new VertexBufferObject();
        vbo.storeFloatInVbo(attrib, size, data);
        this.vbos.add(vbo);
        GL30.glBindVertexArray((int)0);
    }

    public void modifyBufferData(int attrib, int size, float[] data) {
        GL30.glBindVertexArray((int)this.vaoID);
        VertexBufferObject vbo = this.vbos.get(attrib);
        vbo.storeFloatInVbo(attrib, size, data);
        GL30.glBindVertexArray((int)0);
    }

    public void modifyBufferData(int attrib, int size, FloatBuffer data) {
        GL30.glBindVertexArray((int)this.vaoID);
        VertexBufferObject vbo = this.vbos.get(attrib);
        vbo.storeFloatInVbo(attrib, size, data);
        GL30.glBindVertexArray((int)0);
    }

    public void bufferDataInt(int attrib, int size, int[] data) {
        GL30.glBindVertexArray((int)this.vaoID);
        VertexBufferObject vbo = new VertexBufferObject();
        vbo.storeIntInVbo(attrib, size, data);
        this.vbos.add(vbo);
        GL30.glBindVertexArray((int)0);
    }

    public void bufferDataElement(int[] data) {
        GL30.glBindVertexArray((int)this.vaoID);
        if (this.elementVbo == null) {
            this.elementVbo = new VertexBufferObject();
        }
        this.elementVbo.storeIndices(data);
        GL30.glBindVertexArray((int)0);
    }

    public void bindVao() {
        GL30.glBindVertexArray((int)this.vaoID);
        for (int i = 0; i < this.vbos.size(); ++i) {
            GL20.glEnableVertexAttribArray((int)i);
        }
        if (this.elementVbo != null) {
            GL15.glBindBuffer((int)34963, (int)this.elementVbo.getVboID());
        }
    }

    public void unbindVao() {
        GL30.glBindVertexArray((int)0);
        for (int i = 0; i < this.vbos.size(); ++i) {
            GL20.glDisableVertexAttribArray((int)i);
        }
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public void clearVao() {
        GL30.glDeleteVertexArrays((int)this.vaoID);
        for (VertexBufferObject vbo : this.vbos) {
            vbo.clearVbo();
        }
        if (this.elementVbo != null) {
            this.elementVbo.clearVbo();
        }
    }

    public int getVertexNumber() {
        return 0;
    }
}

