/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.renderer.debug;

import com.epicfight.client.opengl.VertexArrayObject;
import com.epicfight.client.renderer.ShaderRenderer;
import com.epicfight.client.shader.FigureShader;
import com.epicfight.client.shader.Shaders;
import com.epicfight.physics.ColliderLine;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec4f;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderLine
extends ShaderRenderer<FigureShader> {
    protected static final int[] CUBE_VERTEX_INDEX = new int[]{0, 1};
    protected final VertexArrayObject vao;

    public RenderLine(IResourceManager resourceManager) {
        super(null);
        this.shader = Shaders.FIGURE_SHADER;
        this.vao = new VertexArrayObject();
        this.vao.bufferDataFloat(0, 3, BufferUtils.createFloatBuffer((int)0));
        this.vao.bufferDataElement(CUBE_VERTEX_INDEX);
    }

    public void doRender(MathUtils gu, ColliderLine obb) {
        this.vao.modifyBufferData(0, 3, obb.getVertexBuffer());
        ((FigureShader)this.shader).start();
        ((FigureShader)this.shader).loadUniforms(MathUtils.getViewMatrix(), gu.getCurrentProjectionMatrix(), new Vec4f(1.0f, 1.0f, 1.0f, 1.0f));
        this.vao.bindVao();
        GL11.glDrawElements((int)1, (int)CUBE_VERTEX_INDEX.length, (int)5125, (long)0L);
        this.vao.unbindVao();
        ((FigureShader)this.shader).stop();
    }
}

