/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.renderer.debug;

import com.epicfight.client.opengl.VertexArrayObject;
import com.epicfight.client.renderer.ShaderRenderer;
import com.epicfight.client.shader.FigureShader;
import com.epicfight.client.shader.Shaders;
import com.epicfight.physics.ColliderOBB;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec4f;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderOBB
extends ShaderRenderer<FigureShader> {
    private static final int[] CUBE_VERTEX_INDEX = new int[]{0, 1, 1, 2, 2, 3, 3, 0, 1, 7, 0, 6, 3, 5, 2, 4, 4, 5, 5, 6, 6, 7, 7, 4};
    private VertexArrayObject vao;

    public RenderOBB(IResourceManager resourceManager) {
        super(null);
        this.shader = Shaders.FIGURE_SHADER;
        this.vao = new VertexArrayObject();
        this.vao.bufferDataFloat(0, 3, BufferUtils.createFloatBuffer((int)0));
    }

    public void doRender(MathUtils gu, ColliderOBB obb) {
        int vertexLength = obb.is3d() ? CUBE_VERTEX_INDEX.length : 8;
        ((FigureShader)this.shader).start();
        ((FigureShader)this.shader).loadUniforms(MathUtils.getViewMatrix(), gu.getCurrentProjectionMatrix(), new Vec4f(1.0f, 1.0f, 1.0f, 1.0f));
        this.vao.bufferDataElement(CUBE_VERTEX_INDEX);
        this.vao.modifyBufferData(0, 3, obb.getVertexBuffer());
        this.vao.bindVao();
        GL11.glDrawElements((int)1, (int)vertexLength, (int)5125, (long)0L);
        this.vao.unbindVao();
        ((FigureShader)this.shader).stop();
    }

    @Override
    public void clearRenderer() {
    }
}

