/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.renderer.entity;

import com.epicfight.animation.Joint;
import com.epicfight.animation.types.attack.AttackAnimation;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.client.events.RenderEvents;
import com.epicfight.client.model.Mesh;
import com.epicfight.client.renderer.ShaderRenderer;
import com.epicfight.client.shader.ArmatureShader;
import com.epicfight.main.ModCore;
import com.epicfight.model.Armature;
import com.epicfight.model.Model;
import com.epicfight.physics.Collider;
import com.epicfight.physics.ColliderOBB;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec3f;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class RenderArmatureEntity<T extends EntitydataLiving>
extends ShaderRenderer<ArmatureShader> {
    public RenderArmatureEntity(IResourceManager resourceManager, ResourceLocation textureLocation) {
        super(textureLocation);
    }

    public void doRender(T entitydata) {
        this.renderModel(entitydata);
    }

    public void renderModel(T entitydata) {
        AnimatorClient animator;
        Object entity = ((EntitydataLiving)entitydata).getOriginalEntity();
        Model entityModel = ((EntitydataLiving)entitydata).getEntityModel();
        Mesh mesh = entityModel.getMesh();
        Armature armature = entityModel.getArmature();
        MathUtils gu = ModCore.graphicUtils;
        int sky = 0;
        int block = 0;
        int i = entity.func_70070_b();
        if (entity.func_70027_ad()) {
            i = 0xF00000;
        }
        sky = i / 0x100000;
        block = i % 65536 / 16;
        armature.initializeTransform();
        this.transformJoints(entitydata, armature);
        ((EntitydataLiving)entitydata).getClientAnimator().setPoseToModel();
        Mat4f modelMatrix = ((EntitydataLiving)entitydata).getModelMatrix();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2918, (FloatBuffer)buf);
        int fogMode = GL11.glGetInteger((int)2917);
        if ((fogMode -= 2047) > 1000) {
            fogMode = 0;
        }
        Object[] uniforms = new Object[]{modelMatrix, MathUtils.getViewMatrix(), gu.getCurrentProjectionMatrix(), gu.getTotalLight(sky, block), armature.getJointTransforms(), new Vec3f(buf.get(0), buf.get(1), buf.get(2)), Float.valueOf(GL11.glGetFloat((int)2915)), Float.valueOf(GL11.glGetFloat((int)2916)), Float.valueOf(GL11.glGetFloat((int)2914)), fogMode};
        if (!((EntitydataLiving)entitydata).getOriginalEntity().func_82150_aj()) {
            ((ArmatureShader)this.shader).start();
            ((ArmatureShader)this.shader).loadUniforms(uniforms);
            GlStateManager.func_179129_p();
            RenderArmatureEntity.bindTexture(this.getEntityTexture(entitydata));
            mesh.getVao().bindVao();
            GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
            mesh.getVao().unbindVao();
            ((ArmatureShader)this.shader).stop();
        }
        this.renderLayer(entitydata, uniforms);
        this.renderItem(entitydata);
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && (animator = ((EntitydataLiving)entitydata).getClientAnimator()).getPlayAnimation() instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)animator.getPlayAnimation();
            if (((EntitydataLiving)entitydata).getEntityState() == EntitydataLiving.EntityState.CONTACT) {
                int index = attackAnimation.getIndexer();
                Collider collider = attackAnimation.getCollider((EntitydataFighter)entitydata);
                Joint joint = armature.getJointHierarcy();
                while (index >> 5 != 0) {
                    joint = joint.getSubJoints().get(((index >>= 5) & 0x1F) - 1);
                }
                Mat4f mat = joint.getAnimatedTransform();
                collider.transform(Mat4f.mul(modelMatrix, mat, null));
                RenderEvents.obb.doRender(ModCore.graphicUtils, (ColliderOBB)collider);
            }
        }
        GlStateManager.func_179089_o();
    }

    protected void transformJoint(int jointId, Armature modelArmature, Mat4f mat) {
        Joint joint = modelArmature.findJointById(jointId);
        Mat4f.mul(joint.getAnimatedTransform(), mat, joint.getAnimatedTransform());
    }

    protected void renderHeldItem(T entitydata, ItemStack stack, EnumHand hand) {
        if (stack.func_77973_b() != Items.field_190931_a) {
            ModCore.renderManager.getItemRenderer(stack.func_77973_b()).doRenderItem(stack, (EntitydataLiving)entitydata, hand);
        }
    }

    protected ResourceLocation getEntityTexture(T entitydata) {
        return super.getTexture();
    }

    protected abstract void transformJoints(T var1, Armature var2);

    protected abstract void renderItem(T var1);

    protected abstract void renderLayer(T var1, Object[] var2);

    @Override
    public void clearRenderer() {
        ((ArmatureShader)this.shader).clearShader();
    }
}

