/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.renderer.entity;

import com.epicfight.capabilities.entity.mob.EntitydataEnderman;
import com.epicfight.client.events.RenderEvents;
import com.epicfight.client.model.Mesh;
import com.epicfight.client.renderer.entity.RenderBiped;
import com.epicfight.client.shader.ArmatureShader;
import com.epicfight.client.shader.Shaders;
import com.epicfight.model.Armature;
import com.epicfight.model.Model;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderEndermanMod
extends RenderBiped<EntitydataEnderman> {
    private static final ResourceLocation eyetexture = new ResourceLocation("textures/entity/enderman/enderman_eyes.png");

    public RenderEndermanMod(IResourceManager resourceManager) {
        super(resourceManager, new ResourceLocation("textures/entity/enderman/enderman.png"));
        this.shader = Shaders.SHINING_EYE_SHADER;
    }

    @Override
    public void renderModel(EntitydataEnderman entitydata) {
        GlStateManager.func_179138_g((int)33991);
        RenderBiped.bindTexture(eyetexture);
        GlStateManager.func_179138_g((int)33984);
        super.renderModel(entitydata);
    }

    @Override
    public void renderLayer(EntitydataEnderman entitydata, Object[] uniforms) {
        if (((EntityEnderman)entitydata.getOriginalEntity()).func_82150_aj()) {
            GlStateManager.func_179147_l();
            Model entityModel = entitydata.getEntityModel();
            Mesh mesh = entityModel.getMesh();
            RenderEndermanMod.bindTexture(RenderEvents.nullTexture);
            ((ArmatureShader)this.shader).start();
            ((ArmatureShader)this.shader).loadUniforms(uniforms);
            GlStateManager.func_179129_p();
            mesh.getVao().bindVao();
            GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
            mesh.getVao().unbindVao();
            ((ArmatureShader)this.shader).stop();
            GlStateManager.func_179084_k();
        }
    }

    @Override
    protected void transformJoints(EntitydataEnderman entitydata, Armature modelArmature) {
        this.transformJoint(15, modelArmature, entitydata.getHeadMatrix());
        if (entitydata.isRaging()) {
            boolean isDead = ((EntityEnderman)entitydata.getOriginalEntity()).func_110143_aJ() <= 0.0f;
            Mat4f head = new Mat4f();
            Mat4f shaking = new Mat4f();
            Random rand = ((EntityEnderman)entitydata.getOriginalEntity()).func_70681_au();
            Mat4f.translate(new Vec3f(0.0f, 0.5f, 0.0f), head, head);
            Mat4f.translate(new Vec3f((float)rand.nextGaussian() * 0.02f, 0.0f, (float)rand.nextGaussian() * 0.02f), shaking, shaking);
            if (isDead) {
                this.transformJoint(0, modelArmature, shaking);
                this.transformJoint(16, modelArmature, head);
            } else {
                Mat4f.add(shaking, head, head);
                this.transformJoint(16, modelArmature, head);
            }
        }
    }
}

