/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.renderer.item;

import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.MathUtils;
import com.epicfight.utils.math.Vec3f;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderItemBase {
    protected Mat4f correctionMatrix = new Mat4f();

    public RenderItemBase() {
        Mat4f.rotate((float)Math.toRadians(-80.0), new Vec3f(1.0f, 0.0f, 0.0f), this.correctionMatrix, this.correctionMatrix);
        Mat4f.translate(new Vec3f(0.0f, 0.1f, 0.0f), this.correctionMatrix, this.correctionMatrix);
    }

    public void doRenderItem(ItemStack stack, EntitydataLiving itemHolder, EnumHand hand) {
        this.renderItem(stack, itemHolder, this.correctionMatrix, hand, false);
    }

    public void renderItem(ItemStack stack, EntitydataLiving itemHolder, Mat4f correction, EnumHand hand, boolean renderRawModel) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        Mat4f modelMatrix = new Mat4f(correction);
        int jointId = hand == EnumHand.MAIN_HAND ? 11 : 15;
        Mat4f.mul(itemHolder.getEntityModel().getArmature().findJointById(jointId).getAnimatedTransform(), modelMatrix, modelMatrix);
        Mat4f.mul(itemHolder.getModelMatrix(), modelMatrix, modelMatrix);
        Mat4f modelViewMatrix = Mat4f.mul(MathUtils.getViewMatrix(), modelMatrix, null);
        modelViewMatrix.store(buf);
        buf.flip();
        GL11.glLoadMatrix((FloatBuffer)buf);
        if (renderRawModel) {
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        } else {
            Minecraft.func_71410_x().func_175597_ag().func_178099_a(itemHolder.getOriginalEntity(), stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        }
        GlStateManager.func_179121_F();
    }

    public void renderItemAsArmor(ItemStack stack, EntitydataLiving itemHolder) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        Mat4f modelMatrix = new Mat4f();
        Mat4f.translate(new Vec3f(0.0f, 0.2f, 0.0f), modelMatrix, modelMatrix);
        Mat4f.mul(itemHolder.getEntityModel().getArmature().findJointById(7).getAnimatedTransform(), modelMatrix, modelMatrix);
        Mat4f.mul(itemHolder.getModelMatrix(), modelMatrix, modelMatrix);
        Mat4f.scale(new Vec3f(0.6f, 0.6f, 0.6f), modelMatrix, modelMatrix);
        Mat4f modelViewMatrix = Mat4f.mul(MathUtils.getViewMatrix(), modelMatrix, null);
        modelViewMatrix.store(buf);
        buf.flip();
        GL11.glLoadMatrix((FloatBuffer)buf);
        Minecraft.func_71410_x().func_175597_ag().func_178099_a(itemHolder.getOriginalEntity(), stack, ItemCameraTransforms.TransformType.HEAD);
        GlStateManager.func_179121_F();
    }
}

