/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.renderer.layer;

import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.entity.mob.EntitydataZombieVillager;
import com.epicfight.capabilities.item.ArmorCapability;
import com.epicfight.capabilities.item.VanillaArmorCapability;
import com.epicfight.client.model.Mesh;
import com.epicfight.client.renderer.ShaderRenderer;
import com.epicfight.client.shader.ArmorShader;
import com.epicfight.client.shader.Shaders;
import com.epicfight.item.ItemArmorExtend;
import com.epicfight.main.ModCore;
import com.epicfight.model.Model;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import com.epicfight.utils.math.Vec4f;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

public class EquipmentRenerer
extends ShaderRenderer<ArmorShader> {
    private static final Vec4f enchantmentAuraColor = new Vec4f(0.38f, 0.19f, 0.608f, 1.0f);
    private static Map<String, ResourceLocation> ARMOR_MAP;

    public EquipmentRenerer() {
        super(null);
        this.shader = Shaders.BIPED_ARMOR_SHADER;
    }

    public void render(EntitydataLiving entitydata, ItemStack stack, Object[] uniforms) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor) {
            Object entityIn = entitydata.getOriginalEntity();
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            VanillaArmorCapability cap = (VanillaArmorCapability)stack.getCapability(ModCapabilities.CAPABILITY_ITEM, null);
            Model model = cap == null ? ArmorCapability.getBipedArmorModel(armor.func_185083_B_(), entityIn.func_70631_g_()) : cap.getEquipModel(armor.func_185083_B_(), entityIn.func_70631_g_());
            ResourceLocation textureLocation = this.getArmorTexture(stack, (Entity)entityIn, armor.func_185083_B_(), null);
            EquipmentRenerer.bindTexture(textureLocation);
            if (entitydata instanceof EntitydataZombieVillager) {
                Mat4f[] jointTransforms = (Mat4f[])uniforms[4];
                Mat4f headMatrix = new Mat4f();
                float y = entitydata.getOriginalEntity().func_70631_g_() ? 0.08f : 0.11f;
                headMatrix.translate(new Vec3f(0.0f, y, 0.0f));
                Mat4f.mul(headMatrix, jointTransforms[7], jointTransforms[7]);
            }
            Object[] overlayUniforms = new Object[1];
            Object[] glintUniforms = new Object[3];
            int overlay = 0;
            int glint = 0;
            if (armor.hasOverlay(stack) && !(item instanceof ItemArmorExtend)) {
                String s2 = String.format("textures/models/armor/%s_layer_%d_overlay.png", armor.func_82812_d().func_179242_c(), armor.func_185083_B_() == EntityEquipmentSlot.LEGS ? 2 : 1);
                GlStateManager.func_179138_g((int)33990);
                EquipmentRenerer.bindTexture(new ResourceLocation(s2));
                overlayUniforms[0] = ModCore.graphicUtils.convertColorToVector(armor.func_82814_b(stack));
                overlay = 1;
            }
            if (stack.func_77962_s()) {
                GlStateManager.func_179138_g((int)33991);
                EquipmentRenerer.bindTexture(new ResourceLocation("textures/misc/enchanted_item_glint.png"));
                Mat4f texTransform1 = new Mat4f();
                Mat4f texTransform2 = new Mat4f();
                Mat4f.scale(new Vec3f(0.33333334f, 0.33333334f, 0.33333334f), texTransform1, texTransform1);
                Mat4f.rotate((float)Math.toRadians(30.0), new Vec3f(0.0f, 0.0f, 1.0f), texTransform1, texTransform1);
                Mat4f.translate(new Vec3f(0.0f, (float)((EntityLivingBase)entitydata.getOriginalEntity()).field_70173_aa * 0.001f * 20.0f, 0.0f), texTransform1, texTransform1);
                Mat4f.scale(new Vec3f(0.33333334f, 0.33333334f, 0.33333334f), texTransform2, texTransform2);
                Mat4f.rotate((float)Math.toRadians(-30.0), new Vec3f(0.0f, 0.0f, 1.0f), texTransform2, texTransform2);
                Mat4f.translate(new Vec3f(0.0f, (float)((EntityLivingBase)entitydata.getOriginalEntity()).field_70173_aa * 0.004f * 20.0f, 0.0f), texTransform2, texTransform2);
                glintUniforms[0] = enchantmentAuraColor;
                glintUniforms[1] = texTransform1;
                glintUniforms[2] = texTransform2;
                glint = 1;
            }
            Object[] uniformTotal = new Object[14];
            System.arraycopy(uniforms, 0, uniformTotal, 0, uniforms.length);
            if (overlay > 0) {
                System.arraycopy(overlayUniforms, 0, uniformTotal, uniforms.length, overlayUniforms.length);
            }
            if (glint > 0) {
                System.arraycopy(glintUniforms, 0, uniformTotal, uniforms.length + overlay, glintUniforms.length);
            }
            ((ArmorShader)this.shader).start();
            ((ArmorShader)this.shader).loadUniforms(overlay, glint, uniformTotal);
            Mesh mesh = model.getMesh();
            mesh.getVao().bindVao();
            GL11.glDrawElements((int)4, (int)mesh.getVertexNumber(), (int)5125, (long)0L);
            mesh.getVao().unbindVao();
            ((ArmorShader)this.shader).stop();
            GlStateManager.func_179138_g((int)33984);
        } else if (item != Items.field_190931_a) {
            ModCore.renderManager.getItemRenderer(stack.func_77973_b()).renderItemAsArmor(stack, entitydata);
        }
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_82812_d().func_179242_c();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EntityEquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    static {
        Field fld = ObfuscationReflectionHelper.findField(LayerArmorBase.class, (String)"field_177191_j");
        fld.setAccessible(true);
        try {
            ARMOR_MAP = (Map)fld.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

