/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.shader;

import com.epicfight.client.shader.ArmatureShader;
import com.epicfight.client.shader.uniforms.UniformInt;
import com.epicfight.client.shader.uniforms.UniformMatrix;
import com.epicfight.client.shader.uniforms.UniformVector4f;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec4f;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmorShader
extends ArmatureShader {
    private final UniformInt overlay;
    private final UniformVector4f ovelayColor;
    private final UniformInt texture1;
    private final UniformInt texture2;
    private final UniformInt glint;
    private final UniformInt texture3;
    private final UniformVector4f glintColor;
    private final UniformMatrix textureTransform1;
    private final UniformMatrix textureTransform2;

    public ArmorShader(IResourceManager resourceManager, int vertexShaderId, int jointNumber) {
        super(vertexShaderId, ArmorShader.loadShader(resourceManager, new ResourceLocation("epicfight", "shaders/armorf.glsl"), 35632), jointNumber);
        this.texture1 = new UniformInt(this.programID, "texture2D");
        this.texture2 = new UniformInt(this.programID, "overlay2D");
        this.texture3 = new UniformInt(this.programID, "glint2D");
        this.overlay = new UniformInt(this.programID, "overlay");
        this.ovelayColor = new UniformVector4f(this.programID, "overlayColor");
        this.glint = new UniformInt(this.programID, "glint");
        this.glintColor = new UniformVector4f(this.programID, "glintColor");
        this.textureTransform1 = new UniformMatrix(this.programID, "glintTransform1");
        this.textureTransform2 = new UniformMatrix(this.programID, "glintTransform2");
    }

    public void loadUniforms(int overlay, int glint, Object ... objects) {
        super.loadUniforms(objects);
        this.texture1.loadUniformVariable(0);
        this.texture2.loadUniformVariable(6);
        this.texture3.loadUniformVariable(7);
        this.overlay.loadUniformVariable(overlay);
        if (overlay > 0) {
            this.ovelayColor.loadUniformVariable((Vec4f)objects[10]);
        }
        this.glint.loadUniformVariable(glint);
        if (glint > 0) {
            int i = 10 + overlay;
            this.glintColor.loadUniformVariable((Vec4f)objects[i]);
            this.textureTransform1.loadUniformVariable((Mat4f)objects[++i]);
            this.textureTransform2.loadUniformVariable((Mat4f)objects[++i]);
        }
    }
}

