/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.client.shader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public abstract class ShaderProgram {
    protected final int programID;
    protected final int vertexShaderID;
    protected final int geometryShaderID;
    protected final int fragmentShaderID;
    private int attribCount = 0;

    public ShaderProgram(int vertexId, int fragmentId) {
        this.vertexShaderID = vertexId;
        this.fragmentShaderID = fragmentId;
        this.programID = GL20.glCreateProgram();
        this.geometryShaderID = 0;
    }

    public ShaderProgram(IResourceManager resourceManager, ResourceLocation vertex, ResourceLocation fragment) {
        this.vertexShaderID = ShaderProgram.loadShader(resourceManager, vertex, 35633);
        this.fragmentShaderID = ShaderProgram.loadShader(resourceManager, fragment, 35632);
        this.programID = GL20.glCreateProgram();
        this.geometryShaderID = 0;
    }

    public ShaderProgram(IResourceManager resourceManager, ResourceLocation vertex, ResourceLocation geometry, ResourceLocation fragment) {
        this.vertexShaderID = ShaderProgram.loadShader(resourceManager, vertex, 35633);
        this.geometryShaderID = ShaderProgram.loadShader(resourceManager, geometry, 36313);
        this.fragmentShaderID = ShaderProgram.loadShader(resourceManager, fragment, 35632);
        this.programID = GL20.glCreateProgram();
    }

    public void bindShader() {
        GL20.glAttachShader((int)this.programID, (int)this.vertexShaderID);
        GL20.glAttachShader((int)this.programID, (int)this.fragmentShaderID);
        if (this.geometryShaderID != 0) {
            GL20.glAttachShader((int)this.programID, (int)this.geometryShaderID);
        }
        this.bindAttributes();
        GL20.glLinkProgram((int)this.programID);
        GL20.glValidateProgram((int)this.programID);
    }

    protected abstract void bindAttributes();

    public abstract void loadUniforms(Object ... var1);

    public void setMultiOutput(int attachment, String outName) {
        GL30.glBindFragDataLocation((int)this.programID, (int)attachment, (CharSequence)outName);
    }

    public void start() {
        GL20.glUseProgram((int)this.programID);
    }

    public void stop() {
        GL20.glUseProgram((int)0);
    }

    public void clearShader() {
        this.stop();
        GL20.glDetachShader((int)this.programID, (int)this.vertexShaderID);
        GL20.glDetachShader((int)this.programID, (int)this.fragmentShaderID);
        GL20.glDeleteShader((int)this.vertexShaderID);
        GL20.glDeleteShader((int)this.fragmentShaderID);
        GL20.glDeleteProgram((int)this.programID);
        if (this.geometryShaderID != 0) {
            GL20.glDetachShader((int)this.programID, (int)this.geometryShaderID);
            GL20.glDeleteShader((int)this.geometryShaderID);
        }
    }

    protected void bindAttribute(String variableName) {
        GL20.glBindAttribLocation((int)this.programID, (int)this.attribCount++, (CharSequence)variableName);
    }

    protected static int loadShader(IResourceManager resourceManager, ResourceLocation resourceLocation, int type) {
        CharBuffer abyte = null;
        try {
            BufferedInputStream bufferedinputstream = new BufferedInputStream(resourceManager.func_110536_a(resourceLocation).func_110527_b());
            abyte = CharBuffer.wrap(ShaderProgram.toCharArray(bufferedinputstream));
        }
        catch (IOException e) {
            System.err.println("shader loading error : " + resourceLocation);
            e.printStackTrace();
            return 0;
        }
        int shaderID = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shaderID, (CharSequence)abyte);
        GL20.glCompileShader((int)shaderID);
        if (GL20.glGetShaderi((int)shaderID, (int)35713) == 0) {
            System.out.println(GL20.glGetShaderInfoLog((int)shaderID, (int)500));
            System.err.println("Could not compile shader!");
        }
        return shaderID;
    }

    protected static char[] toCharArray(BufferedInputStream stream) throws IOException {
        char[] abyte;
        try {
            abyte = IOUtils.toCharArray((InputStream)stream);
        }
        finally {
            stream.close();
        }
        return abyte;
    }

    protected static byte[] toByteArray(BufferedInputStream stream) throws IOException {
        byte[] abyte;
        try {
            abyte = IOUtils.toByteArray((InputStream)stream);
        }
        finally {
            stream.close();
        }
        return abyte;
    }

    int getVertexShaderId() {
        return this.vertexShaderID;
    }
}

