/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.collada;

import com.epicfight.animation.Joint;
import com.epicfight.animation.JointKeyframe;
import com.epicfight.animation.JointTransform;
import com.epicfight.animation.Pose;
import com.epicfight.animation.Quaternion;
import com.epicfight.animation.TransformSheet;
import com.epicfight.animation.types.MixLinkAnimation;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.collada.ColladaModelLoader;
import com.epicfight.collada.xml.XmlNode;
import com.epicfight.collada.xml.XmlParser;
import com.epicfight.model.Armature;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class AnimationDataExtractor {
    private static final Mat4f CORRECTION = new Mat4f().rotate((float)Math.toRadians(-90.0), new Vec3f(1.0f, 0.0f, 0.0f));

    private static TransformSheet getTransformSheet(String[] times, String[] trasnformMatrix, Mat4f invLocalTransform, boolean correct) {
        ArrayList<JointKeyframe> keyframeList = new ArrayList<JointKeyframe>();
        for (int i = 0; i < times.length; ++i) {
            float timeStamp = Float.parseFloat(times[i]);
            if (timeStamp < 0.0f) continue;
            float[] matrixValue = new float[16];
            for (int j = 0; j < 16; ++j) {
                matrixValue[j] = Float.parseFloat(trasnformMatrix[i * 16 + j]);
            }
            FloatBuffer buffer = FloatBuffer.allocate(16);
            buffer.put(matrixValue);
            buffer.flip();
            Mat4f matrix = new Mat4f();
            matrix.load(buffer);
            matrix.transpose();
            if (correct) {
                Mat4f.mul(CORRECTION, matrix, matrix);
            }
            Mat4f.mul(invLocalTransform, matrix, matrix);
            JointTransform transform = new JointTransform(new Vec3f(matrix.m30, matrix.m31, matrix.m32), Quaternion.fromMatrix(matrix));
            keyframeList.add(new JointKeyframe(timeStamp, transform));
        }
        TransformSheet sheet = new TransformSheet(keyframeList);
        return sheet;
    }

    public static void extractAnimation(ResourceLocation location, StaticAnimation data, Armature armature) {
        BufferedReader bufreader = null;
        try {
            bufreader = new BufferedReader(new InputStreamReader(ColladaModelLoader.getInputStream(location)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        XmlNode rootNode = XmlParser.loadXmlFile(bufreader);
        List<XmlNode> jointAnimations = rootNode.getChild("library_animations").getChildren("animation");
        boolean root = true;
        for (XmlNode jointAnimation : jointAnimations) {
            String jointName = jointAnimation.getAttribute("id");
            String input = jointAnimation.getChild("sampler").getChildWithAttribute("input", "semantic", "INPUT").getAttribute("source").substring(1);
            String output = jointAnimation.getChild("sampler").getChildWithAttribute("input", "semantic", "OUTPUT").getAttribute("source").substring(1);
            String[] timeValue = jointAnimation.getChildWithAttribute("source", "id", input).getChild("float_array").getData().split(" ");
            String[] matrixArray = jointAnimation.getChildWithAttribute("source", "id", output).getChild("float_array").getData().split(" ");
            String fir = jointName.substring(9);
            String sec = fir.substring(0, fir.length() - 12);
            Joint joint = armature.findJointByName(sec);
            TransformSheet sheet = AnimationDataExtractor.getTransformSheet(timeValue, matrixArray, Mat4f.invert(joint.getLocalTrasnform(), null), root);
            data.addSheet(sec, sheet);
            data.setTotalTime(Float.parseFloat(timeValue[timeValue.length - 1]));
            root = false;
        }
    }

    public static MixLinkAnimation getLinkAnimation(float convertTime, Pose currentPose) {
        MixLinkAnimation result = new MixLinkAnimation(currentPose);
        result.setTotalTime(convertTime);
        return result;
    }
}

