/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.collada;

import com.epicfight.animation.Joint;
import com.epicfight.client.model.Mesh;
import com.epicfight.collada.GeometryDataExtractor;
import com.epicfight.collada.JointDataExtractor;
import com.epicfight.collada.SkinDataExtractor;
import com.epicfight.collada.VertexData;
import com.epicfight.collada.xml.XmlNode;
import com.epicfight.collada.xml.XmlParser;
import com.epicfight.main.ModCore;
import com.epicfight.model.Armature;
import com.epicfight.utils.math.Mat4f;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColladaModelLoader {
    @SideOnly(value=Side.CLIENT)
    public static Mesh getArmatureModelData(ResourceLocation path) throws IOException {
        BufferedReader bufreader = null;
        try {
            bufreader = new BufferedReader(new InputStreamReader(ColladaModelLoader.getInputStream(path)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        XmlNode rootNode = XmlParser.loadXmlFile(bufreader);
        GeometryDataExtractor geometry = new GeometryDataExtractor(rootNode.getChild("library_geometries").getChild("geometry").getChild("mesh"));
        SkinDataExtractor skin = new SkinDataExtractor(rootNode.getChild("library_controllers").getChild("controller").getChild("skin"));
        List<VertexData> vertices = geometry.extractVertexNumber();
        skin.extractSkinData(vertices);
        geometry.extractGeometryData(vertices);
        Mesh meshdata = new Mesh(geometry.getIndexNumber());
        VertexData.loadVertexInformation(vertices, geometry.getIndices(), meshdata, true);
        return meshdata;
    }

    public static Armature getArmature(ResourceLocation path) throws IOException {
        BufferedReader bufreader = null;
        try {
            bufreader = new BufferedReader(new InputStreamReader(ColladaModelLoader.getInputStream(path)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        XmlNode rootNode = XmlParser.loadXmlFile(bufreader);
        JointDataExtractor skeleton = new JointDataExtractor(rootNode.getChild("library_visual_scenes").getChild("visual_scene").getChildWithAttribute("node", "id", "Armature"));
        Joint joint = skeleton.extractSkeletonData();
        joint.setInversedModelTransform(new Mat4f());
        Armature armature = new Armature(skeleton.getJointNumber(), joint, skeleton.getJointTable());
        return armature;
    }

    public static BufferedInputStream getInputStream(ResourceLocation resourceLocation) throws FileNotFoundException {
        BufferedInputStream inputStream = new BufferedInputStream(ModCore.class.getResourceAsStream("/assets/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a()));
        return inputStream;
    }
}

