/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.collada;

import com.epicfight.animation.Joint;
import com.epicfight.collada.xml.XmlNode;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JointDataExtractor {
    private static final Mat4f CORRECTION = new Mat4f().rotate((float)Math.toRadians(-90.0), new Vec3f(1.0f, 0.0f, 0.0f));
    private int index = 0;
    private int jointNumber = 1;
    private XmlNode skeleton;
    private Map<Integer, Joint> joints = new HashMap<Integer, Joint>();

    public JointDataExtractor(XmlNode skeleton) {
        this.skeleton = skeleton;
    }

    public Joint extractSkeletonData() {
        XmlNode rootNode = this.skeleton.getChild("node");
        Joint root = this.getRootJoint(rootNode);
        this.bindJointData(root, rootNode.getChildren("node"));
        return root;
    }

    private void bindJointData(Joint root, List<XmlNode> nodes) {
        for (XmlNode node : nodes) {
            Joint joint = this.getJoint(node);
            root.addSubJoint(joint);
            this.bindJointData(joint, node.getChildren("node"));
        }
    }

    private Joint getRootJoint(XmlNode node) {
        String name = node.getAttribute("sid");
        String[] matrixData = node.getChild("matrix").getData().split(" ");
        Mat4f jointTransform = this.convertStringToMatrix(matrixData);
        Mat4f.mul(CORRECTION, jointTransform, jointTransform);
        Joint joint = new Joint(name, this.index++, jointTransform);
        this.joints.put(joint.getId(), joint);
        return joint;
    }

    private Joint getJoint(XmlNode node) {
        ++this.jointNumber;
        String name = node.getAttribute("sid");
        String[] matrixData = node.getChild("matrix").getData().split(" ");
        Mat4f jointTransform = this.convertStringToMatrix(matrixData);
        Joint joint = new Joint(name, this.index++, jointTransform);
        this.joints.put(joint.getId(), joint);
        return joint;
    }

    private Mat4f convertStringToMatrix(String[] data) {
        float[] mat4 = new float[16];
        for (int i = 0; i < 16; ++i) {
            mat4[i] = Float.parseFloat(data[i]);
        }
        FloatBuffer floatbuffer = FloatBuffer.allocate(16);
        floatbuffer.put(mat4);
        floatbuffer.flip();
        Mat4f transform = new Mat4f();
        transform.load(floatbuffer);
        transform.transpose();
        return transform;
    }

    public Map<Integer, Joint> getJointTable() {
        return this.joints;
    }

    public int getJointNumber() {
        return this.jointNumber;
    }
}

