/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.entity.ai;

import com.epicfight.animation.types.attack.AttackAnimation;
import com.epicfight.capabilities.entity.EntitydataMob;
import com.epicfight.network.PacketManager;
import com.epicfight.network.server.STCPlayAnimationTarget;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIAttackPattern
extends EntityAIBase {
    protected final EntityCreature attacker;
    protected final EntitydataMob mobdata;
    protected final double minDist;
    protected final double maxDist;
    protected final List<AttackAnimation> pattern;
    protected final boolean affectHorizon;
    protected int patternIndex;

    public EntityAIAttackPattern(EntitydataMob mobdata, EntityCreature attacker, double minDist, double maxDIst, boolean affectHorizon, List<AttackAnimation> pattern) {
        this.attacker = attacker;
        this.mobdata = mobdata;
        this.minDist = minDist;
        this.maxDist = maxDIst;
        this.pattern = pattern;
        this.patternIndex = 0;
        this.affectHorizon = affectHorizon;
        this.func_75248_a(8);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        return this.isValidTarget(entitylivingbase) && this.isTargetInRange(entitylivingbase);
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        return this.pattern.size() <= this.patternIndex && this.isValidTarget(entitylivingbase) && this.isTargetInRange(entitylivingbase);
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
        this.patternIndex %= this.pattern.size();
    }

    protected boolean canExecuteAttack() {
        return !this.mobdata.isInaction();
    }

    public void func_75246_d() {
        if (this.canExecuteAttack()) {
            AttackAnimation att = this.pattern.get(this.patternIndex++);
            this.patternIndex %= this.pattern.size();
            this.mobdata.getServerAnimator().playAnimation(att, 0.0f);
            PacketManager.packetHandler.sendToAllTracking((IMessage)new STCPlayAnimationTarget(att.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
        }
    }

    protected boolean isTargetInRange(EntityLivingBase attackTarget) {
        double targetRange = this.attacker.func_70092_e(attackTarget.field_70165_t, attackTarget.func_174813_aQ().field_72338_b, attackTarget.field_70161_v);
        return targetRange <= this.maxDist && targetRange >= this.minDist && this.isInSameHorizontalPosition(attackTarget);
    }

    protected boolean isValidTarget(EntityLivingBase attackTarget) {
        return attackTarget != null && attackTarget.func_70089_S() && (!(attackTarget instanceof EntityPlayer) || !((EntityPlayer)attackTarget).func_175149_v() && !((EntityPlayer)attackTarget).func_184812_l_());
    }

    protected boolean isInSameHorizontalPosition(EntityLivingBase attackTarget) {
        if (this.affectHorizon) {
            return Math.abs(this.attacker.field_70163_u - attackTarget.field_70163_u) <= (double)this.attacker.func_70047_e();
        }
        return true;
    }
}

