/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.entity.ai;

import com.epicfight.capabilities.entity.EntitydataMob;
import com.epicfight.network.PacketManager;
import com.epicfight.network.server.STCLivingMotionChange;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIChase
extends EntityAIBase {
    World world;
    protected EntityCreature attacker;
    protected final EntitydataMob entitydata;
    double speedTowardsTarget;
    boolean longMemory;
    Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    protected final int chasingAnimationId;
    protected final int walkingAnimationId;
    protected final boolean motionChange;

    public EntityAIChase(EntitydataMob entitydata, EntityCreature creature, double speedIn, boolean useLongMemory, int chasingId, int walkId, boolean motionChange) {
        this.entitydata = entitydata;
        this.attacker = creature;
        this.world = creature.field_70170_p;
        this.longMemory = useLongMemory;
        this.chasingAnimationId = chasingId;
        this.walkingAnimationId = walkId;
        this.motionChange = motionChange;
        this.speedTowardsTarget = speedIn;
        this.func_75248_a(3);
    }

    public EntityAIChase(EntitydataMob entitydata, EntityCreature creature, double speedIn, boolean useLongMemory, int chasingId, int walkId) {
        this(entitydata, creature, speedIn, useLongMemory, chasingId, walkId, true);
    }

    public EntityAIChase(EntitydataMob entitydata, EntityCreature creature, double speedIn, boolean useLongMemory) {
        this(entitydata, creature, speedIn, useLongMemory, 0, 0, false);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.delayCounter = 2 + this.attacker.func_70681_au().nextInt(3);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(entitylivingbase) >= this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.attacker.func_180485_d(new BlockPos((Entity)entitylivingbase))) {
            return false;
        }
        return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.delayCounter = 0;
        if (this.motionChange) {
            PacketManager.packetHandler.sendToAllTracking((IMessage)new STCLivingMotionChange(4, this.chasingAnimationId, this.attacker.func_145782_y()), (Entity)this.attacker);
        }
    }

    public void func_75251_c() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase instanceof EntityPlayer && (((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_())) {
            this.attacker.func_70624_b((EntityLivingBase)null);
        }
        this.attacker.func_70661_as().func_75499_g();
        if (this.motionChange) {
            PacketManager.packetHandler.sendToAllTracking((IMessage)new STCLivingMotionChange(4, this.walkingAnimationId, this.attacker.func_145782_y()), (Entity)this.attacker);
        }
    }

    public void func_75246_d() {
        if (this.entitydata.isInaction()) {
            this.delayCounter = -1;
            return;
        }
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.field_70161_v;
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                this.delayCounter += 2;
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }
}

