/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.events;

import com.epicfight.animation.Animator;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.CapabilityEntity;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.EntitydataLiving;
import com.epicfight.capabilities.entity.IRangedAttackMobCapability;
import com.epicfight.capabilities.entity.mob.EntitydataBipedMob;
import com.epicfight.capabilities.entity.mob.EntitydataEnderman;
import com.epicfight.capabilities.entity.player.EntitydataPlayerMP;
import com.epicfight.capabilities.item.CapabilityItem;
import com.epicfight.gamedata.Animations;
import com.epicfight.network.PacketManager;
import com.epicfight.network.client.CTSPlayAnimation;
import com.epicfight.network.server.STCPlayAnimation;
import com.epicfight.potion.ModPotions;
import com.epicfight.skills.Skill;
import com.epicfight.utils.game.IExtendedDamageSource;
import com.epicfight.utils.game.IndirectDamageSourceExtended;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class EntityEvents {
    private static List<CapabilityEntity> unInitializedEntitiesClient = Lists.newArrayList();
    private static List<CapabilityEntity> unInitializedEntitiesServer = Lists.newArrayList();
    private static final UUID WEIGHT_PANELTY_ID = UUID.fromString("414fed9e-e5e3-11ea-adc1-0242ac120002");

    @SubscribeEvent
    public static void spawnEvent(EntityJoinWorldEvent event) {
        CapabilityEntity entitydata = (CapabilityEntity)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null) {
            entitydata.setEntity(event.getEntity());
            entitydata.init();
            if (entitydata.isRemote()) {
                unInitializedEntitiesClient.add(entitydata);
            } else {
                unInitializedEntitiesServer.add(entitydata);
            }
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingUpdateEvent event) {
        EntitydataLiving entitydata = (EntitydataLiving)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && entitydata.getOriginalEntity() != null) {
            entitydata.update();
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        IExtendedDamageSource extSource = null;
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getSource() instanceof IExtendedDamageSource) {
            extSource = (IExtendedDamageSource)event.getSource();
        } else if (event.getSource() instanceof EntityDamageSourceIndirect) {
            CapabilityEntity attackerdata = (CapabilityEntity)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
            if (attackerdata != null && attackerdata instanceof IRangedAttackMobCapability) {
                extSource = ((IRangedAttackMobCapability)((Object)attackerdata)).getRangedDamageSource(event.getSource().func_76364_f());
            } else if (event.getSource().field_76373_n == "arrow") {
                extSource = new IndirectDamageSourceExtended("arrow", trueSource, event.getSource().func_76364_f(), IExtendedDamageSource.StunType.SHORT);
            }
        }
        if (extSource != null) {
            EntityLivingBase hurtEntity;
            EntitydataLiving hurtEntityCap;
            EntitydataLiving attackerdata;
            float armorIgnore = extSource.getArmorIgnoreRatio();
            float amount = event.getAmount();
            float afterArmorIgnore = event.getAmount() * (1.0f - armorIgnore);
            event.getEntityLiving().field_70172_ad = 0;
            event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110143_aJ() - event.getAmount() * armorIgnore);
            event.setAmount(afterArmorIgnore);
            if (trueSource != null && (attackerdata = (EntitydataLiving)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null && attackerdata instanceof EntitydataFighter) {
                ((EntitydataFighter)attackerdata).lastDealtDamageAmount += amount * armorIgnore;
            }
            if (event.getAmount() > 0.0f && (hurtEntityCap = (EntitydataLiving)(hurtEntity = event.getEntityLiving()).getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
                StaticAnimation hitAnimation = null;
                float extendStunTime = 0.0f;
                switch (extSource.getStunType()) {
                    case SHORT: {
                        if (hurtEntity.func_70644_a(ModPotions.SUPERARMOR_EFFECT) || hurtEntityCap.getStunResistance() != 0.0f) break;
                        int i = EnchantmentHelper.func_77501_a((EntityLivingBase)((EntityLivingBase)trueSource));
                        float totalStunTime = (float)((double)(0.25f + extSource.getImpact() * 0.1f + 0.1f * (float)i) * (40.0 / hurtEntityCap.getWeight()));
                        if (!((totalStunTime *= 1.0f - hurtEntityCap.getKnockbackTimeReduction()) >= 0.25f)) break;
                        extendStunTime = totalStunTime - 0.25f;
                        boolean flag = extendStunTime > 0.44f;
                        IExtendedDamageSource.StunType stunType = flag ? IExtendedDamageSource.StunType.LONG : IExtendedDamageSource.StunType.SHORT;
                        hitAnimation = hurtEntityCap.getHitAnimation(stunType);
                        extendStunTime = flag ? 0.0f : extendStunTime;
                        break;
                    }
                    case LONG: {
                        hitAnimation = hurtEntity.func_70644_a(ModPotions.SUPERARMOR_EFFECT) ? null : hurtEntityCap.getHitAnimation(IExtendedDamageSource.StunType.LONG);
                        break;
                    }
                    case HOLD: {
                        hitAnimation = hurtEntityCap.getHitAnimation(IExtendedDamageSource.StunType.SHORT);
                    }
                }
                if (hitAnimation != null) {
                    hurtEntityCap.knockBackEntity(trueSource, 0.15f + extendStunTime);
                    hurtEntityCap.setKnockbackReduction();
                    ((Animator)hurtEntityCap.getAnimator()).playAnimation(hitAnimation, extendStunTime);
                    PacketManager.packetHandler.sendToAllTracking((IMessage)new STCPlayAnimation(hitAnimation.getId(), hurtEntity.func_145782_y(), extendStunTime), (Entity)hurtEntity);
                    if (hurtEntity instanceof EntityPlayerMP) {
                        PacketManager.packetHandler.sendTo((IMessage)new STCPlayAnimation(hitAnimation.getId(), hurtEntity.func_145782_y(), extendStunTime), (EntityPlayerMP)hurtEntity);
                    }
                }
            }
        }
        if (event.getEntityLiving().func_184587_cr() && event.getEntityLiving().func_184607_cu().func_77973_b() == Items.field_185159_cQ && event.getEntityLiving() instanceof EntityPlayer) {
            event.getEntityLiving().field_70170_p.func_184133_a((EntityPlayer)event.getEntityLiving(), event.getEntityLiving().func_180425_c(), SoundEvents.field_187767_eL, event.getEntityLiving().func_184176_by(), 1.0f, 0.8f + event.getEntityLiving().func_70681_au().nextFloat() * 0.4f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        EntitydataLiving attacker;
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getSource() instanceof IExtendedDamageSource && trueSource != null && (attacker = (EntitydataLiving)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null && attacker instanceof EntitydataFighter) {
            ((EntitydataFighter)attacker).lastDealtDamageAmount += event.getAmount();
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        EntitydataLiving entitydata = (EntitydataLiving)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && !event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving().func_110143_aJ() > 0.0f && !entitydata.attackEntityFrom(event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        EntitydataLiving entitydata = (EntitydataLiving)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null) {
            ((Animator)entitydata.getAnimator()).playDeathAnimation();
        }
    }

    @SubscribeEvent
    public static void arrowHitEvent(ProjectileImpactEvent.Arrow event) {
        if (event.getRayTraceResult().field_72308_g != null && event.getArrow().field_70250_c != null && event.getRayTraceResult().field_72308_g.equals((Object)event.getArrow().field_70250_c.func_184187_bx())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getFrom().func_77973_b() == event.getTo().func_77973_b()) {
            return;
        }
        if (event.getSlot() == EntityEquipmentSlot.MAINHAND) {
            EntitydataLiving entitycap = (EntitydataLiving)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
            if (entitycap != null) {
                entitycap.cancelUsingItem();
                if (entitycap instanceof EntitydataPlayerMP) {
                    CapabilityItem toCap = (CapabilityItem)event.getTo().getCapability(ModCapabilities.CAPABILITY_ITEM, null);
                    EntitydataPlayerMP playercap = (EntitydataPlayerMP)entitycap;
                    if (toCap != null && toCap.hasSpecialAttack()) {
                        playercap.getSkill(Skill.SkillSlot.WEAPON_SPECIAL_ATTACK).setSkill(toCap.getSpecialAttack());
                    } else {
                        playercap.getSkill(Skill.SkillSlot.WEAPON_SPECIAL_ATTACK).setSkill(null);
                    }
                    entitycap.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_188479_b(WEIGHT_PANELTY_ID);
                    float weaponSpeed = (float)entitycap.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                    for (AttributeModifier attributeModifier : event.getTo().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                        weaponSpeed = (float)((double)weaponSpeed + attributeModifier.func_111164_d());
                    }
                    entitycap.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111121_a(new AttributeModifier(WEIGHT_PANELTY_ID, "weightpanelty modifier", (double)(-playercap.getWeightPaneltyMultiplier()) * 0.1 * (double)weaponSpeed, 0));
                }
            }
        } else if (event.getSlot().func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            CapabilityItem fromCap = (CapabilityItem)event.getFrom().getCapability(ModCapabilities.CAPABILITY_ITEM, null);
            CapabilityItem toCap = (CapabilityItem)event.getTo().getCapability(ModCapabilities.CAPABILITY_ITEM, null);
            if (fromCap != null) {
                event.getEntityLiving().func_110140_aT().func_111148_a(fromCap.getItemAttributeModifiers(event.getSlot()));
            }
            if (toCap != null) {
                event.getEntityLiving().func_110140_aT().func_111147_b(toCap.getItemAttributeModifiers(event.getSlot()));
            }
            if (event.getEntityLiving() instanceof EntityPlayerMP) {
                EntitydataPlayerMP playercap = (EntitydataPlayerMP)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                playercap.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_188479_b(WEIGHT_PANELTY_ID);
                float weaponSpeed = (float)playercap.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                for (AttributeModifier attributeModifier : playercap.getOriginalEntity().func_184614_ca().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                    weaponSpeed += (float)attributeModifier.func_111164_d();
                }
                playercap.getOriginalEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f).func_111121_a(new AttributeModifier(WEIGHT_PANELTY_ID, "weightpanelty modifier", (double)(-playercap.getWeightPaneltyMultiplier()) * 0.1 * (double)weaponSpeed, 0));
            }
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        CapabilityEntity mountEntity = (CapabilityEntity)event.getEntityMounting().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (!event.getWorldObj().field_72995_K && mountEntity instanceof EntitydataBipedMob && mountEntity.getOriginalEntity() != null && event.getEntityBeingMounted() instanceof EntityCreature) {
            ((EntitydataBipedMob)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void targetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving().equals((Object)event.getTarget())) {
            event.getEntityLiving().func_70604_c(null);
            if (event.getEntityLiving() instanceof EntityLiving) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void tpEvent(EnderTeleportEvent event) {
        EntityEnderman enderman;
        EntitydataEnderman endermandata;
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getEntityLiving() instanceof EntityEnderman && (endermandata = (EntitydataEnderman)(enderman = (EntityEnderman)entity).getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
            if (endermandata.isInaction()) {
                for (Entity collideEntity : enderman.field_70170_p.func_72872_a(Entity.class, enderman.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2))) {
                    if (!(collideEntity instanceof IProjectile)) continue;
                    return;
                }
                event.setCanceled(true);
            } else if (endermandata.isRaging()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        EntitydataLiving entitydata = (EntitydataLiving)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && entitydata.isRemote() && !entitydata.isInaction() && !event.getEntity().func_70090_H()) {
            ((Animator)entitydata.getAnimator()).playAnimation(Animations.BIPED_JUMP, 0.0f);
            PacketManager.packetHandler.sendToServer((IMessage)new CTSPlayAnimation(Animations.BIPED_JUMP.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        float distance;
        EntitydataLiving entitydata = (EntitydataLiving)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && !entitydata.isInaction() && (distance = event.getDistance()) > 5.0f) {
            ((Animator)entitydata.getAnimator()).playAnimation(Animations.BIPED_LAND_DAMAGE, 0.0f);
        }
    }

    @SubscribeEvent
    public static void tickClientEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (CapabilityEntity cap : unInitializedEntitiesClient) {
                cap.postInit();
            }
            unInitializedEntitiesClient.clear();
        }
    }

    @SubscribeEvent
    public static void tickServerEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (CapabilityEntity cap : unInitializedEntitiesServer) {
                cap.postInit();
            }
            unInitializedEntitiesServer.clear();
        }
    }
}

