/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.gamedata;

import com.epicfight.animation.types.AimingAnimation;
import com.epicfight.animation.types.DeathAnimation;
import com.epicfight.animation.types.DodgingAnimation;
import com.epicfight.animation.types.HitAnimation;
import com.epicfight.animation.types.MirrorAnimation;
import com.epicfight.animation.types.MovementAnimation;
import com.epicfight.animation.types.OneShotAnimation;
import com.epicfight.animation.types.ShootingAnimation;
import com.epicfight.animation.types.StaticAnimation;
import com.epicfight.animation.types.attack.AAAnimation;
import com.epicfight.animation.types.attack.AADashAnimation;
import com.epicfight.animation.types.attack.AttackAnimation;
import com.epicfight.animation.types.attack.MobLongAttackAnimation;
import com.epicfight.animation.types.attack.MountAttackAnimation;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.capabilities.entity.mob.MobAttackPatterns;
import com.epicfight.gamedata.Colliders;
import com.epicfight.gamedata.Models;
import com.epicfight.gamedata.Sounds;
import com.epicfight.model.Armature;
import com.epicfight.utils.game.IExtendedDamageSource;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class Animations {
    public static final Map<Integer, StaticAnimation> animationTable = new HashMap<Integer, StaticAnimation>();
    public static StaticAnimation DUMMY_ANIMATION = new StaticAnimation();
    public static StaticAnimation BIPED_IDLE;
    public static StaticAnimation BIPED_WALK;
    public static StaticAnimation BIPED_RUN;
    public static StaticAnimation BIPED_SNEAK;
    public static StaticAnimation BIPED_SWIM;
    public static StaticAnimation BIPED_KNEEL;
    public static StaticAnimation BIPED_FALL;
    public static StaticAnimation BIPED_FLYING;
    public static StaticAnimation BIPED_MOUNT;
    public static StaticAnimation BIPED_JUMP;
    public static StaticAnimation BIPED_DEATH;
    public static StaticAnimation BIPED_DIG;
    public static StaticAnimation BIPED_RUN_HELDING_WEAPON;
    public static StaticAnimation BIPED_IDLE_MASSIVE_HELD;
    public static StaticAnimation BIPED_WALK_MASSIVE_HELD;
    public static StaticAnimation BIPED_RUN_MASSIVE_HELD;
    public static StaticAnimation BIPED_BOW_AIM;
    public static StaticAnimation BIPED_BOW_SHOT;
    public static StaticAnimation BIPED_HIT_SHORT;
    public static StaticAnimation BIPED_HIT_LONG;
    public static StaticAnimation BIPED_MOUNT_HIT;
    public static StaticAnimation BIPED_LAND_DAMAGE;
    public static StaticAnimation BIPED_BLOCK;
    public static StaticAnimation BIPED_ROLL_FORWARD;
    public static StaticAnimation BIPED_ROLL_BACKWARD;
    public static StaticAnimation BIPED_DODGE_LEFT;
    public static StaticAnimation BIPED_ARMED_MOB_ATTACK1;
    public static StaticAnimation BIPED_ARMED_MOB_ATTACK2;
    public static StaticAnimation CREEPER_IDLE;
    public static StaticAnimation CREEPER_WALK;
    public static StaticAnimation CREEPER_HIT_LONG;
    public static StaticAnimation CREEPER_HIT_SHORT;
    public static StaticAnimation CREEPER_DEATH;
    public static StaticAnimation ENDERMAN_IDLE;
    public static StaticAnimation ENDERMAN_WALK;
    public static StaticAnimation ENDERMAN_DEATH;
    public static StaticAnimation ENDERMAN_HIT_SHORT;
    public static StaticAnimation ENDERMAN_HIT_LONG;
    public static StaticAnimation ENDERMAN_HIT_RAGE;
    public static StaticAnimation ENDERMAN_ATTACK1;
    public static StaticAnimation ENDERMAN_ATTACK2;
    public static StaticAnimation ENDERMAN_RUSH;
    public static StaticAnimation ENDERMAN_RAGE_IDLE;
    public static StaticAnimation ENDERMAN_RAGE_WALK;
    public static StaticAnimation ENDERMAN_GRASP;
    public static StaticAnimation ENDERMAN_KICK1;
    public static StaticAnimation ENDERMAN_KICK2;
    public static StaticAnimation ENDERMAN_KICK3;
    public static StaticAnimation SPIDER_IDLE;
    public static StaticAnimation SPIDER_CRAWL;
    public static StaticAnimation SPIDER_DEATH;
    public static StaticAnimation SPIDER_HIT;
    public static StaticAnimation SPIDER_ATTACK;
    public static StaticAnimation SPIDER_JUMP_ATTACK;
    public static StaticAnimation GOLEM_IDLE;
    public static StaticAnimation GOLEM_WALK;
    public static StaticAnimation GOLEM_DEATH;
    public static StaticAnimation GOLEM_ATTACK1;
    public static StaticAnimation GOLEM_ATTACK2;
    public static StaticAnimation GOLEM_ATTACK3;
    public static StaticAnimation GOLEM_ATTACK4;
    public static StaticAnimation ILLAGER_IDLE;
    public static StaticAnimation ILLAGER_IDLE_AGGRESSIVE;
    public static StaticAnimation ILLAGER_WALK;
    public static StaticAnimation ILLAGER_CHASE;
    public static StaticAnimation ILLAGER_DEATH;
    public static StaticAnimation ILLAGER_HIT_SHORT;
    public static StaticAnimation ILLAGER_HIT_LONG;
    public static StaticAnimation ILLAGER_SWING_AXE1;
    public static StaticAnimation ILLAGER_SWING_AXE2;
    public static StaticAnimation ILLAGER_SWING_AXE3;
    public static StaticAnimation ILLAGER_CAST_SPELL;
    public static StaticAnimation WITCH_DRINKING;
    public static StaticAnimation WITCH_THROWING;
    public static StaticAnimation WITHER_SKELETON_IDLE;
    public static StaticAnimation WITHER_SKELETON_WALK;
    public static StaticAnimation WITHER_SKELETON_CHASE;
    public static StaticAnimation WITHER_SKELETON_ATTACK1;
    public static StaticAnimation WITHER_SKELETON_ATTACK2;
    public static StaticAnimation WITHER_SKELETON_ATTACK3;
    public static StaticAnimation ZOMBIE_IDLE;
    public static StaticAnimation ZOMBIE_WALK;
    public static StaticAnimation ZOMBIE_CHASE;
    public static StaticAnimation ZOMBIE_ATTACK1;
    public static StaticAnimation ZOMBIE_ATTACK2;
    public static StaticAnimation ZOMBIE_ATTACK3;
    public static StaticAnimation ZOMBIE_BABY_RUSH;
    public static StaticAnimation BABY_RUN;
    public static StaticAnimation BABY_DEATH;
    public static StaticAnimation AXE_DASH;
    public static StaticAnimation FIST_AUTO_1;
    public static StaticAnimation FIST_AUTO_2;
    public static StaticAnimation FIST_AUTO_3;
    public static StaticAnimation FIST_DASH;
    public static StaticAnimation SPEAR_AUTO_1;
    public static StaticAnimation SPEAR_TWOHAND_AUTO_1;
    public static StaticAnimation SPEAR_TWOHAND_AUTO_2;
    public static StaticAnimation SPEAR_DASH;
    public static StaticAnimation SPEAR_MOUNT_ATTACK;
    public static StaticAnimation SWORD_AUTO_1;
    public static StaticAnimation SWORD_AUTO_2;
    public static StaticAnimation SWORD_AUTO_3;
    public static StaticAnimation SWORD_AUTO_4;
    public static StaticAnimation SWORD_DASH;
    public static StaticAnimation SWORD_MOUNT_ATTACK;
    public static StaticAnimation GREATSWORD_AUTO_1;
    public static StaticAnimation GREATSWORD_AUTO_2;
    public static StaticAnimation GREATSWORD_DASH;
    public static StaticAnimation TOOL_DASH;
    public static StaticAnimation GUILLOTINE_AXE;
    public static StaticAnimation SWEEPING_EDGE;

    public static StaticAnimation findAnimationDataById(int id) {
        return animationTable.get(id);
    }

    public static void registerAnimationsClient() {
        Armature biped = Models.CLIENT.ENTITY_BIPED.getArmature();
        Armature baby = Models.CLIENT.ENTITY_BABY_ZOMBIE.getArmature();
        Armature crepper = Models.CLIENT.ENTITY_CREEPER.getArmature();
        Armature enderman = Models.CLIENT.ENTITY_ENDERMAN.getArmature();
        Armature spider = Models.CLIENT.ENTITY_SPIDER.getArmature();
        Armature iron_golem = Models.CLIENT.ENTITY_GOLEM.getArmature();
        Armature illager = Models.CLIENT.ENTITY_VINDICATOR.getArmature();
        BIPED_IDLE = new StaticAnimation(0, true, "biped/living/idle.dae").bind(biped);
        BIPED_WALK = new MovementAnimation(1, true, "biped/living/walk.dae").bind(biped);
        BIPED_FLYING = new StaticAnimation(2, true, "biped/living/fly.dae").bind(biped);
        BIPED_RUN = new MovementAnimation(5, true, "biped/living/run.dae").bind(biped);
        BIPED_SNEAK = new MovementAnimation(7, true, "biped/living/sneak.dae").bind(biped);
        BIPED_SWIM = new MovementAnimation(8, true, "biped/living/swim.dae");
        BIPED_KNEEL = new StaticAnimation(10, true, "biped/living/kneel.dae").bind(biped);
        BIPED_FALL = new StaticAnimation(11, false, "biped/living/fall.dae").bind(biped);
        BIPED_MOUNT = new StaticAnimation(12, true, "biped/living/mount.dae").bind(biped);
        BIPED_DIG = new StaticAnimation(15, 0.11f, true, "biped/living/dig.dae").bind(biped);
        BIPED_BOW_AIM = new AimingAnimation(16, 0.16f, false, "biped/combat/bow_aim_mid.dae", "biped/combat/bow_aim_up.dae", "biped/combat/bow_aim_down.dae").bind(biped);
        BIPED_BOW_SHOT = new ShootingAnimation(17, 0.16f, false, "biped/combat/bow_shot_mid.dae", "biped/combat/bow_shot_up.dae", "biped/combat/bow_shot_down.dae").bind(biped);
        BIPED_JUMP = new OneShotAnimation(19, 0.083f, false, "biped/living/jump.dae").bind(biped);
        BIPED_RUN_HELDING_WEAPON = new MovementAnimation(22, true, "biped/living/run_helding_weapon.dae").bind(biped);
        BIPED_BLOCK = new MirrorAnimation(21, 0.25f, true, "biped/combat/block.dae", "biped/combat/block_mirror.dae").bind(biped);
        BIPED_IDLE_MASSIVE_HELD = new MovementAnimation(23, true, "biped/living/massiveheld_idle.dae").bind(biped);
        BIPED_WALK_MASSIVE_HELD = new MovementAnimation(24, true, "biped/living/massiveheld_walk.dae").bind(biped);
        BIPED_RUN_MASSIVE_HELD = new MovementAnimation(25, true, "biped/living/massiveheld_run.dae").bind(biped);
        ZOMBIE_IDLE = new StaticAnimation(100, true, "zombie/living/idle.dae").bind(biped);
        ZOMBIE_WALK = new MovementAnimation(102, true, "zombie/living/walk.dae").bind(biped);
        ZOMBIE_CHASE = new MovementAnimation(103, true, "zombie/living/chase.dae").bind(biped);
        BABY_RUN = new MovementAnimation(104, true, "zombie/living/baby_run.dae").bind(baby);
        CREEPER_IDLE = new StaticAnimation(300, 0.16f, true, "creeper/idle.dae").bind(crepper);
        CREEPER_WALK = new MovementAnimation(301, 0.16f, true, "creeper/walk.dae").bind(crepper);
        ENDERMAN_IDLE = new StaticAnimation(400, true, "enderman/idle.dae").bind(enderman);
        ENDERMAN_WALK = new MovementAnimation(401, true, "enderman/walk.dae").bind(enderman);
        ENDERMAN_RUSH = new StaticAnimation(403, false, "enderman/rush.dae").bind(enderman);
        ENDERMAN_RAGE_IDLE = new StaticAnimation(404, true, "enderman/rage_idle.dae").bind(enderman);
        ENDERMAN_RAGE_WALK = new MovementAnimation(405, true, "enderman/rage_walk.dae").bind(enderman);
        SPIDER_IDLE = new StaticAnimation(600, true, "spider/idle.dae").bind(spider);
        SPIDER_CRAWL = new MovementAnimation(601, true, "spider/crawl.dae").bind(spider);
        GOLEM_IDLE = new StaticAnimation(700, true, "iron_golem/idle.dae").bind(iron_golem);
        GOLEM_WALK = new MovementAnimation(701, true, "iron_golem/walk.dae").bind(iron_golem);
        ILLAGER_IDLE = new StaticAnimation(800, true, "illager/idle.dae").bind(illager);
        ILLAGER_IDLE_AGGRESSIVE = new StaticAnimation(801, true, "illager/idle_aggressive.dae").bind(illager);
        ILLAGER_WALK = new MovementAnimation(802, true, "illager/walk.dae").bind(illager);
        ILLAGER_CHASE = new MovementAnimation(803, true, "illager/chase.dae").bind(illager);
        ILLAGER_CAST_SPELL = new StaticAnimation(804, 0.16f, true, "illager/spellcast.dae").bind(illager);
        WITHER_SKELETON_IDLE = new StaticAnimation(500, true, "skeleton/wither_skeleton_idle.dae").bind(biped);
        WITHER_SKELETON_WALK = new MovementAnimation(501, true, "skeleton/wither_skeleton_walk.dae").bind(biped);
        WITHER_SKELETON_CHASE = new MovementAnimation(502, 0.36f, true, "skeleton/wither_skeleton_chase.dae").bind(biped);
        Animations.registerAnimationCommon(Side.CLIENT);
    }

    public static void registerAnimationsServer() {
        Animations.registerAnimationCommon(Side.SERVER);
    }

    private static void registerAnimationCommon(Side side) {
        Models modeldata = side == Side.CLIENT ? Models.CLIENT : Models.SERVER;
        Armature biped = modeldata.ENTITY_BIPED.getArmature();
        Armature baby = modeldata.ENTITY_BABY_ZOMBIE.getArmature();
        Armature crepper = modeldata.ENTITY_CREEPER.getArmature();
        Armature enderman = modeldata.ENTITY_ENDERMAN.getArmature();
        Armature spider = modeldata.ENTITY_SPIDER.getArmature();
        Armature iron_golem = modeldata.ENTITY_GOLEM.getArmature();
        Armature illager = modeldata.ENTITY_VINDICATOR.getArmature();
        BIPED_LAND_DAMAGE = new HitAnimation(20, 0.08f, "biped/living/land_damage.dae").bind(biped);
        BIPED_ROLL_FORWARD = new DodgingAnimation(1999, 0.09f, false, "biped/combat/roll_forward.dae", 0.6f, 0.5f).bind(biped);
        BIPED_ROLL_BACKWARD = new DodgingAnimation(2000, 0.09f, false, "biped/combat/roll_backward.dae", 0.6f, 0.5f).bind(biped);
        AXE_DASH = new AADashAnimation(1998, 0.25f, 0.08f, 0.4f, 0.46f, 0.91f, null, "111213", "biped/combat/axe_dash.dae").bind(biped);
        FIST_AUTO_1 = new AAAnimation(2001, 0.08f, 0.0f, 0.1f, 0.15f, 4.0f, null, "111313", "biped/combat/fist_auto1.dae").bind(biped);
        FIST_AUTO_2 = new AAAnimation(2002, 0.08f, 0.0f, 0.1f, 0.15f, 4.0f, null, "111213", "biped/combat/fist_auto2.dae").bind(biped);
        FIST_AUTO_3 = new AAAnimation(2003, 0.08f, 0.0f, 0.1f, 0.5f, 4.0f, null, "111313", "biped/combat/fist_auto3.dae").bind(biped);
        FIST_DASH = new AADashAnimation(2004, 0.12f, 0.05f, 0.05f, 0.41f, 0.7f, null, "213", "biped/combat/fist_dash.dae").bind(biped);
        SWORD_AUTO_1 = new AAAnimation(2005, 0.13f, 0.05f, 0.15f, 0.3f, 1.6f, null, "111213", "biped/combat/sword_auto1.dae").bind(biped);
        SWORD_AUTO_2 = new AAAnimation(2006, 0.13f, 0.05f, 0.15f, 0.3f, 1.6f, null, "111213", "biped/combat/sword_auto2.dae").bind(biped);
        SWORD_AUTO_3 = new AAAnimation(2007, 0.13f, 0.05f, 0.15f, 0.3f, 1.6f, null, "111213", "biped/combat/sword_auto3.dae").bind(biped);
        SWORD_AUTO_4 = new AAAnimation(2008, 0.13f, 0.05f, 0.15f, 0.3f, 1.6f, null, "111213", "biped/combat/sword_auto4.dae").bind(biped);
        SWORD_DASH = new AADashAnimation(2009, 0.12f, 0.1f, 0.1f, 0.3f, 0.65f, Colliders.swordDash, "111213", "biped/combat/sword_dash.dae").bind(biped);
        SWORD_MOUNT_ATTACK = new MountAttackAnimation(2010, 0.16f, 0.1f, 0.2f, 0.25f, 0.7f, null, "111213", "biped/combat/sword_mount_attack.dae").bind(biped);
        GREATSWORD_AUTO_1 = new AAAnimation(2050, 0.41f, 0.35f, 0.55f, 0.9f, 0.8f, null, "111213", "biped/combat/greatsword_auto1.dae").bind(biped);
        GREATSWORD_AUTO_2 = new AAAnimation(2051, 0.2f, 0.55f, 0.75f, 1.05f, 0.8f, null, "111213", "biped/combat/greatsword_auto2.dae").bind(biped);
        GREATSWORD_DASH = new AADashAnimation(2052, 0.11f, 0.4f, 0.65f, 0.8f, 1.2f, null, "111213", "biped/combat/greatsword_dash.dae").bind(biped);
        TOOL_DASH = new AADashAnimation(2100, 0.16f, 0.08f, 0.15f, 0.25f, 0.58f, null, "111213", "biped/combat/tool_dash.dae"){

            @Override
            public int getHitEnemies(EntitydataFighter entitydata) {
                return 2;
            }
        }.bind(biped);
        SPEAR_AUTO_1 = new AAAnimation(2200, 0.16f, 0.2f, 0.3f, 0.45f, 1.2f, null, "111213", "biped/combat/spear_auto1.dae").bind(biped);
        SPEAR_TWOHAND_AUTO_1 = new AAAnimation(2201, 0.16f, 0.2f, 0.3f, 0.45f, 1.2f, Colliders.spearSwing, "111213", "biped/combat/spear_twohand_auto1.dae").bind(biped);
        SPEAR_TWOHAND_AUTO_2 = new AAAnimation(2202, 0.16f, 0.2f, 0.3f, 0.45f, 1.2f, Colliders.spearSwing, "111213", "biped/combat/spear_twohand_auto2.dae").bind(biped);
        SPEAR_DASH = new AADashAnimation(2203, 0.16f, 0.23f, 0.28f, 0.5f, 1.2f, null, "111213", "biped/combat/spear_dash.dae").bind(biped);
        SPEAR_MOUNT_ATTACK = new MountAttackAnimation(2245, 0.16f, 0.38f, 0.38f, 0.45f, 0.8f, null, "111213", "biped/combat/spear_mount_attack.dae").bind(biped);
        BIPED_ARMED_MOB_ATTACK1 = new MobLongAttackAnimation(2900, 0.16f, 0.15f, 0.15f, 0.28f, 0.58f, false, null, "111213", "biped/combat/armed_mob_attack1.dae").bind(biped);
        BIPED_ARMED_MOB_ATTACK2 = new MobLongAttackAnimation(2901, 0.16f, 0.15f, 0.15f, 0.28f, 0.58f, false, null, "111213", "biped/combat/armed_mob_attack2.dae").bind(biped);
        BIPED_HIT_SHORT = new HitAnimation(3000, 0.16f, "biped/combat/hit_short.dae").bind(biped);
        BIPED_HIT_LONG = new HitAnimation(3001, 0.08f, "biped/combat/hit_long.dae").bind(biped);
        BIPED_MOUNT_HIT = new HitAnimation(3002, 0.08f, "biped/combat/mount_hit.dae").bind(biped);
        BIPED_DEATH = new DeathAnimation(3003, 0.16f, "biped/living/death.dae").bind(biped);
        CREEPER_HIT_SHORT = new HitAnimation(3400, 0.16f, "creeper/hit_short.dae").bind(crepper);
        CREEPER_HIT_LONG = new HitAnimation(3401, 0.08f, "creeper/hit_long.dae").bind(crepper);
        CREEPER_DEATH = new DeathAnimation(3402, 0.16f, "creeper/death.dae").bind(crepper);
        ENDERMAN_HIT_SHORT = new HitAnimation(3004, 0.16f, "enderman/hit_short.dae").bind(enderman);
        ENDERMAN_HIT_LONG = new HitAnimation(3005, 0.08f, "enderman/hit_long.dae").bind(enderman);
        ENDERMAN_HIT_RAGE = new HitAnimation(3006, 0.16f, "enderman/convert_rampage.dae").bind(enderman);
        ENDERMAN_KICK1 = new AttackAnimation(3007, 0.06f, 0.15f, 0.3f, 0.4f, 0.85f, false, Colliders.endermanStick, "11", "enderman/kick1.dae").bind(enderman);
        ENDERMAN_KICK2 = new AttackAnimation(3008, 0.16f, 0.15f, 0.25f, 0.45f, 0.75f, false, Colliders.endermanStick, "11", "enderman/kick2.dae").bind(enderman);
        ENDERMAN_KICK3 = new MobLongAttackAnimation(3009, 0.33f, 0.35f, 0.45f, 0.6f, 1.25f, false, Colliders.endermanStick, "12", "enderman/kick3.dae").bind(enderman);
        ENDERMAN_ATTACK1 = new AttackAnimation(3010, 0.16f, 0.0f, 0.1f, 0.25f, 0.45f, false, Colliders.endermanStick, "11113", "enderman/attack1.dae").bind(enderman);
        ENDERMAN_ATTACK2 = new AttackAnimation(3011, 0.16f, 0.0f, 0.1f, 0.25f, 0.45f, false, Colliders.endermanStick, "11213", "enderman/attack2.dae").bind(enderman);
        ENDERMAN_GRASP = new MobLongAttackAnimation(3012, 0.06f, 0.5f, 0.45f, 1.0f, 1.0f, false, Colliders.endermanStick, "111213", "enderman/grasp.dae").bind(enderman);
        ENDERMAN_DEATH = new DeathAnimation(3013, 0.16f, "enderman/death.dae").bind(enderman);
        GOLEM_ATTACK1 = new AttackAnimation(3200, 0.2f, 0.1f, 0.15f, 0.25f, 0.9f, false, Colliders.headbutt, "11", "iron_golem/attack1.dae").bind(iron_golem);
        GOLEM_ATTACK2 = new AttackAnimation(3201, 0.34f, 0.1f, 0.4f, 0.55f, 1.15f, false, Colliders.golemSmashDown, "11121", "iron_golem/attack2.dae"){

            @Override
            public SoundEvent getAttackSound(EntitydataFighter entitydata) {
                return Sounds.BLUNT_HIT_HARD;
            }
        }.bind(iron_golem);
        GOLEM_ATTACK3 = new MobLongAttackAnimation(3202, 0.16f, 0.4f, 0.4f, 0.5f, 0.9f, false, Colliders.golemSwingArm, "11131", "iron_golem/attack3.dae").bind(iron_golem);
        GOLEM_ATTACK4 = new MobLongAttackAnimation(3203, 0.16f, 0.4f, 0.4f, 0.5f, 0.9f, false, Colliders.golemSwingArm, "11121", "iron_golem/attack4.dae").bind(iron_golem);
        GOLEM_DEATH = new DeathAnimation(3204, 0.11f, "iron_golem/death.dae").bind(iron_golem);
        ILLAGER_HIT_SHORT = new HitAnimation(3300, 0.16f, "illager/hit_short.dae").bind(illager);
        ILLAGER_HIT_LONG = new HitAnimation(3301, 0.16f, "illager/hit_long.dae").bind(illager);
        ILLAGER_DEATH = new DeathAnimation(3302, 0.11f, "illager/death.dae").bind(illager);
        ILLAGER_SWING_AXE1 = new MobLongAttackAnimation(3303, 0.21f, 0.21f, 0.41f, 0.46f, 0.71f, false, Colliders.tools, "111213", "illager/swing_axe1.dae").bind(illager);
        ILLAGER_SWING_AXE2 = new MobLongAttackAnimation(3304, 0.21f, 0.21f, 0.41f, 0.46f, 0.71f, false, Colliders.tools, "111213", "illager/swing_axe2.dae").bind(illager);
        ILLAGER_SWING_AXE3 = new MobLongAttackAnimation(3305, 0.05f, 0.5f, 0.62f, 0.75f, 1.0f, true, Colliders.tools, "111213", "illager/swing_axe3.dae").bind(illager);
        WITCH_DRINKING = new StaticAnimation(3306, 0.16f, false, "illager/drink.dae").bind(illager);
        WITCH_THROWING = new AttackAnimation(3307, 0.11f, 1.0f, 0.0f, 0.0f, 0.0f, false, null, "", "illager/throw.dae").bind(illager);
        SPIDER_ATTACK = new AttackAnimation(3100, 0.16f, 0.31f, 0.31f, 0.36f, 0.44f, false, Colliders.headbutt, "1", "spider/attack.dae").bind(spider);
        SPIDER_JUMP_ATTACK = new MobLongAttackAnimation(3101, 0.16f, 0.25f, 0.25f, 0.41f, 0.8f, true, Colliders.headbutt, "1", "spider/jump_attack.dae").bind(spider);
        SPIDER_HIT = new HitAnimation(3102, 0.08f, "spider/hit.dae").bind(spider);
        SPIDER_DEATH = new DeathAnimation(3103, 0.16f, "spider/death.dae").bind(spider);
        WITHER_SKELETON_ATTACK1 = new MobLongAttackAnimation(3500, 0.16f, 0.31f, 0.31f, 0.41f, 0.7f, false, Colliders.swordDash, "111213", "skeleton/wither_skeleton_attack1.dae").bind(biped);
        WITHER_SKELETON_ATTACK2 = new MobLongAttackAnimation(3501, 0.16f, 0.31f, 0.31f, 0.41f, 0.7f, false, Colliders.sword, "111213", "skeleton/wither_skeleton_attack2.dae").bind(biped);
        WITHER_SKELETON_ATTACK3 = new MobLongAttackAnimation(3502, 0.16f, 0.31f, 0.31f, 0.41f, 0.7f, false, Colliders.sword, "111213", "skeleton/wither_skeleton_attack3.dae").bind(biped);
        ZOMBIE_ATTACK1 = new MobLongAttackAnimation(4000, 0.1f, 0.3f, 0.35f, 0.55f, 0.85f, false, Colliders.fist, "111213", "zombie/combat/attack1.dae").bind(biped);
        ZOMBIE_ATTACK2 = new MobLongAttackAnimation(4001, 0.1f, 0.3f, 0.33f, 0.55f, 0.85f, false, Colliders.fist, "111313", "zombie/combat/attack2.dae").bind(biped);
        ZOMBIE_ATTACK3 = new MobLongAttackAnimation(4002, 0.1f, 0.5f, 0.5f, 0.5f, 1.15f, false, Colliders.headbutt, "113", "zombie/combat/attack3.dae").bind(biped);
        BABY_DEATH = new DeathAnimation(4004, 0.16f, "zombie/living/baby_death.dae").bind(baby);
        SWEEPING_EDGE = new AttackAnimation(5000, 0.08f, 0.1f, 0.3f, 0.5f, 0.75f, false, Colliders.swordSwingFast, "111213", "biped/combat/sword_special.dae"){

            @Override
            public float getDamageAmount(EntitydataFighter entitydata, Entity target) {
                return entitydata.getDamageToEntity(target) * 2.0f;
            }

            @Override
            public IExtendedDamageSource getDamageSourceExt(EntitydataFighter entitydata) {
                IExtendedDamageSource extDamage = entitydata.getDamageSource(IExtendedDamageSource.StunType.LONG);
                extDamage.setArmorIgnore(25.0f);
                return extDamage;
            }

            @Override
            public int getHitEnemies(EntitydataFighter entitydata) {
                return 3;
            }
        }.bind(biped);
        GUILLOTINE_AXE = new AttackAnimation(5003, 0.12f, 0.2f, 0.35f, 0.5f, 0.85f, true, null, "111213", "biped/combat/axe_special.dae"){

            @Override
            public float getDamageAmount(EntitydataFighter entitydata, Entity target) {
                return entitydata.getDamageToEntity(target) * 2.5f;
            }

            @Override
            public IExtendedDamageSource getDamageSourceExt(EntitydataFighter entitydata) {
                IExtendedDamageSource extDamage = entitydata.getDamageSource(IExtendedDamageSource.StunType.LONG);
                extDamage.setArmorIgnore(40.0f);
                return extDamage;
            }

            @Override
            public int getHitEnemies(EntitydataFighter entitydata) {
                return 1;
            }
        }.bind(biped);
        MobAttackPatterns.setVariousMobAttackPatterns();
    }
}

