/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.item;

import com.epicfight.capabilities.item.ModWeaponCapability;
import com.epicfight.client.animation.AnimatorClient;
import com.epicfight.gamedata.Animations;
import com.epicfight.gamedata.Colliders;
import com.epicfight.gamedata.Sounds;
import com.epicfight.item.ItemWeapon;
import com.google.common.collect.Multimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSpear
extends ItemWeapon {
    private final Item.ToolMaterial material;
    private final float attackDamage;

    public ItemSpear(Item.ToolMaterial materialIn) {
        this.field_77777_bU = 1;
        this.func_77656_e(materialIn.func_77997_a());
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.material = materialIn;
        this.attackDamage = 3.0f + this.material.func_78000_c();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    @Override
    public void setWeaponCapability() {
        this.capability = new ModWeaponCapability(null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.spearNarrow, 0.0, 1.0, 1, false, true, Animations.SPEAR_MOUNT_ATTACK);
        this.capability.addAutoAttackCombos(Animations.SPEAR_AUTO_1);
        this.capability.addAutoAttackCombos(Animations.SPEAR_DASH);
        this.capability.addTwohandAutoAttackCombos(Animations.SPEAR_TWOHAND_AUTO_1);
        this.capability.addTwohandAutoAttackCombos(Animations.SPEAR_TWOHAND_AUTO_2);
        this.capability.addTwohandAutoAttackCombos(Animations.SPEAR_DASH);
        this.capability.setTwoHandStyleAttribute(0.0, 1.0, 3);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.capability.addLivingMotionChanger(AnimatorClient.LivingMotion.RUNNING, Animations.BIPED_RUN_HELDING_WEAPON);
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.8, 0));
        }
        return multimap;
    }
}

