/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.network.server;

import com.epicfight.animation.Animator;
import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.EntitydataLiving;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class STCPlayAnimation
implements IMessage {
    protected int animationId;
    protected int entityId;
    protected float modifyTime;
    protected boolean mixLayer;

    public STCPlayAnimation() {
        this.animationId = 0;
        this.entityId = 0;
        this.modifyTime = 0.0f;
        this.mixLayer = false;
    }

    public STCPlayAnimation(int animation, int entityId, float modifyTime) {
        this(animation, entityId, modifyTime, false);
    }

    public STCPlayAnimation(int animation, int entityId, float modifyTime, boolean mixLayer) {
        this.animationId = animation;
        this.entityId = entityId;
        this.modifyTime = modifyTime;
        this.mixLayer = mixLayer;
    }

    public void fromBytes(ByteBuf buf) {
        this.animationId = buf.readInt();
        this.entityId = buf.readInt();
        this.modifyTime = buf.readFloat();
        this.mixLayer = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.animationId);
        buf.writeInt(this.entityId);
        buf.writeFloat(this.modifyTime);
        buf.writeBoolean(this.mixLayer);
    }

    public <T extends STCPlayAnimation> void onArrive() {
        Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(this.entityId);
        if (entity == null) {
            return;
        }
        EntitydataLiving entitydata = (EntitydataLiving)entity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (this.animationId < 0) {
            entitydata.getClientAnimator().offMixLayer();
            entitydata.getClientAnimator().playLoopMotion();
        } else if (this.mixLayer) {
            entitydata.getClientAnimator().playMixLayerAnimation(this.animationId, "Thigh_L", "Thigh_R");
        } else {
            ((Animator)entitydata.getAnimator()).playAnimation(this.animationId, this.modifyTime);
        }
    }

    public static class Handler
    implements IMessageHandler<STCPlayAnimation, IMessage> {
        public IMessage onMessage(STCPlayAnimation message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> message.onArrive());
            return null;
        }
    }
}

