/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.physics;

import com.epicfight.physics.Collider;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import com.epicfight.utils.math.Vec4f;
import java.nio.FloatBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class ColliderLine
extends Collider {
    private Vec3f modelVec;
    private Vec3f worldVec;

    public ColliderLine(AxisAlignedBB entityCallAABB, float posX, float posY, float posZ, float vecX, float vecY, float vecZ) {
        super(new Vec3f(posX, posY, posZ), entityCallAABB);
        this.modelVec = new Vec3f(vecX, vecY, vecZ);
        this.worldVec = new Vec3f();
    }

    @Override
    public void transform(Mat4f mat) {
        Vec4f tempVector = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        Mat4f rotationMatrix = new Mat4f(mat);
        rotationMatrix.m30 = 0.0f;
        rotationMatrix.m31 = 0.0f;
        rotationMatrix.m32 = 0.0f;
        tempVector.x = this.modelVec.x;
        tempVector.y = this.modelVec.y;
        tempVector.z = this.modelVec.z;
        Mat4f.transform(rotationMatrix, tempVector, tempVector);
        this.worldVec.x = tempVector.x;
        this.worldVec.y = tempVector.y;
        this.worldVec.z = tempVector.z;
        super.transform(mat);
    }

    @Override
    public boolean isCollideWith(Entity entity) {
        float endZ;
        float endY;
        float maxStart;
        float minEnd;
        float temp;
        float endX;
        AxisAlignedBB opponent = entity.func_174813_aQ();
        if (this.worldVec.x == 0.0f && ((double)this.worldCenter.x < opponent.field_72340_a || (double)this.worldCenter.x > opponent.field_72336_d)) {
            return false;
        }
        float startX = MathHelper.func_76131_a((float)((float)(opponent.field_72340_a + (double)this.worldCenter.x) / -this.worldVec.x), (float)0.0f, (float)1.0f);
        if (startX > (endX = MathHelper.func_76131_a((float)((float)(opponent.field_72336_d + (double)this.worldCenter.x) / -this.worldVec.x), (float)0.0f, (float)1.0f))) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if ((minEnd = endX) == (maxStart = startX)) {
            return false;
        }
        if (this.worldVec.y == 0.0f && ((double)this.worldCenter.y < opponent.field_72338_b || (double)this.worldCenter.y > opponent.field_72337_e)) {
            return false;
        }
        float startY = MathHelper.func_76131_a((float)((float)(opponent.field_72338_b - (double)this.worldCenter.y) / this.worldVec.y), (float)0.0f, (float)1.0f);
        if (startY > (endY = MathHelper.func_76131_a((float)((float)(opponent.field_72337_e - (double)this.worldCenter.y) / this.worldVec.y), (float)0.0f, (float)1.0f))) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        maxStart = maxStart < startY ? startY : maxStart;
        float f = minEnd = minEnd > endY ? endY : minEnd;
        if (maxStart >= minEnd) {
            return false;
        }
        if (this.worldVec.z == 0.0f && ((double)this.worldCenter.z < opponent.field_72339_c || (double)this.worldCenter.z > opponent.field_72334_f)) {
            return false;
        }
        float startZ = MathHelper.func_76131_a((float)((float)(opponent.field_72339_c + (double)this.worldCenter.z) / -this.worldVec.z), (float)0.0f, (float)1.0f);
        if (startZ > (endZ = MathHelper.func_76131_a((float)((float)(opponent.field_72334_f + (double)this.worldCenter.z) / -this.worldVec.z), (float)0.0f, (float)1.0f))) {
            temp = startZ;
            startZ = endZ;
            endZ = temp;
        }
        maxStart = maxStart < startZ ? startZ : maxStart;
        float f2 = minEnd = minEnd > endZ ? endZ : minEnd;
        return !(maxStart >= minEnd);
    }

    @Override
    public FloatBuffer getVertexBuffer() {
        FloatBuffer buf = FloatBuffer.allocate(6);
        buf.put(this.worldCenter.x);
        buf.put(this.worldCenter.y);
        buf.put(this.worldCenter.z);
        buf.put(this.worldCenter.x + this.worldVec.x);
        buf.put(this.worldCenter.y + this.worldVec.y);
        buf.put(this.worldCenter.z + this.worldVec.z);
        buf.flip();
        return buf;
    }
}

