/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.physics;

import com.epicfight.physics.Collider;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import com.epicfight.utils.math.Vec4f;
import java.nio.FloatBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;

public class ColliderPlane
extends Collider {
    private Vec3f[] modelPos;
    private Vec3f[] worldPos;

    public ColliderPlane(Vec3f center, AxisAlignedBB entityCallAABB) {
        super(center, entityCallAABB);
    }

    public ColliderPlane(AxisAlignedBB entityCallAABB, float centerX, float centerY, float centerZ, float pos1X, float pos1Y, float pos1Z, float pos2X, float pos2Y, float pos2Z) {
        super(new Vec3f(centerX, centerY, centerZ), entityCallAABB);
        this.modelPos = new Vec3f[2];
        this.worldPos = new Vec3f[2];
        this.modelPos[0] = new Vec3f(pos1X, pos1Y, pos1Z);
        this.modelPos[1] = new Vec3f(pos2X, pos2Y, pos2Z);
        this.worldPos[0] = new Vec3f();
        this.worldPos[1] = new Vec3f();
    }

    @Override
    public boolean isCollideWith(Entity entity) {
        AxisAlignedBB opponent = entity.func_174813_aQ();
        Vec3f planeNorm = Vec3f.cross(this.worldPos[0], this.worldPos[1], null);
        Vec3f pos = new Vec3f();
        Vec3f neg = new Vec3f();
        if (planeNorm.x >= 0.0f) {
            pos.x = (float)opponent.field_72336_d;
            neg.x = (float)opponent.field_72340_a;
        } else {
            pos.x = (float)opponent.field_72340_a;
            neg.x = (float)opponent.field_72336_d;
        }
        if (planeNorm.y >= 0.0f) {
            pos.y = (float)opponent.field_72337_e;
            neg.y = (float)opponent.field_72338_b;
        } else {
            pos.y = (float)opponent.field_72338_b;
            neg.y = (float)opponent.field_72337_e;
        }
        if (planeNorm.z >= 0.0f) {
            pos.z = (float)opponent.field_72334_f;
            neg.z = (float)opponent.field_72339_c;
        } else {
            pos.z = (float)opponent.field_72339_c;
            neg.z = (float)opponent.field_72334_f;
        }
        float planeD = Vec3f.dot(planeNorm, this.worldCenter);
        float dot1 = Vec3f.dot(planeNorm, pos) - planeD;
        if (dot1 < 0.0f) {
            return false;
        }
        float dot2 = Vec3f.dot(planeNorm, neg) - planeD;
        return !(dot2 > 0.0f);
    }

    @Override
    public void transform(Mat4f mat) {
        Vec4f tempVector = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        Mat4f rotationMatrix = new Mat4f(mat);
        rotationMatrix.m30 = 0.0f;
        rotationMatrix.m31 = 0.0f;
        rotationMatrix.m32 = 0.0f;
        for (int i = 0; i < 2; ++i) {
            tempVector.x = this.modelPos[i].x;
            tempVector.y = this.modelPos[i].y;
            tempVector.z = this.modelPos[i].z;
            Mat4f.transform(rotationMatrix, tempVector, tempVector);
            this.worldPos[i].x = tempVector.x;
            this.worldPos[i].y = tempVector.y;
            this.worldPos[i].z = tempVector.z;
        }
        super.transform(mat);
    }

    @Override
    public FloatBuffer getVertexBuffer() {
        FloatBuffer buf = FloatBuffer.allocate(12);
        buf.put(this.worldCenter.x + this.worldPos[0].x);
        buf.put(this.worldCenter.y + this.worldPos[0].y);
        buf.put(this.worldCenter.z + this.worldPos[0].z);
        buf.put(this.worldCenter.x + this.worldPos[1].x);
        buf.put(this.worldCenter.y + this.worldPos[1].y);
        buf.put(this.worldCenter.z + this.worldPos[1].z);
        buf.put(this.worldCenter.x - this.worldPos[0].x);
        buf.put(this.worldCenter.y - this.worldPos[0].y);
        buf.put(this.worldCenter.z - this.worldPos[0].z);
        buf.put(this.worldCenter.x - this.worldPos[1].x);
        buf.put(this.worldCenter.y - this.worldPos[1].y);
        buf.put(this.worldCenter.z - this.worldPos[1].z);
        buf.flip();
        return buf;
    }
}

