/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.playerclass;

import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.skills.Skill;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;

public class PlayerClass {
    public final Skill skill1;
    public final Skill skill2;
    public final Skill skill3;
    public final Skill skill4;
    public final Skill evasion;
    public final String className;
    public final List<PlayerClass> precedeClasses;
    public final List<Item> mainWeapons;
    public final float weightPanelty;

    public PlayerClass(@Nullable Skill skill1, @Nullable Skill skill2, @Nullable Skill skill3, @Nullable Skill skill4, Skill evasion, float minimunPaneltyWeight, String className, List<Item> mainWeapons, PlayerClass ... precedeClasses) {
        this.skill1 = skill1;
        this.skill2 = skill2;
        this.skill3 = skill3;
        this.skill4 = skill4;
        this.evasion = evasion;
        this.className = className;
        this.precedeClasses = new ArrayList<PlayerClass>();
        this.weightPanelty = minimunPaneltyWeight;
        this.mainWeapons = mainWeapons == null ? new ArrayList<Item>() : mainWeapons;
        if (precedeClasses != null) {
            for (PlayerClass class_ : precedeClasses) {
                this.precedeClasses.add(class_);
            }
        }
    }

    public List<Skill> getSkillSet() {
        ArrayList skillset = Lists.newArrayList();
        skillset.add(this.skill1);
        skillset.add(this.skill2);
        skillset.add(this.skill3);
        skillset.add(this.skill4);
        skillset.add(this.evasion);
        return skillset;
    }

    public boolean canChangeClass(EntitydataPlayer player) {
        if (this.precedeClasses == null) {
            return true;
        }
        for (PlayerClass precedeClass : this.precedeClasses) {
            if (!player.playerClass.equals(precedeClass)) continue;
            return true;
        }
        return false;
    }
}

