/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.skills;

import com.epicfight.capabilities.entity.player.EntitydataPlayerMP;
import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Skill {
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation textureLocation;
    @SideOnly(value=Side.CLIENT)
    protected List<String> tooltipInfo;
    protected final float restriction;
    protected final SkillSlot slot;

    public Skill(SkillSlot index, float restriction, ResourceLocation textureLocation) {
        this.restriction = restriction;
        this.slot = index;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.textureLocation = textureLocation;
            this.tooltipInfo = Lists.newArrayList();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Skill setTooltip(String line) {
        this.tooltipInfo.add(line);
        return this;
    }

    public abstract void executeOnClient(EntitydataPlayerSP var1, Object[] var2);

    public abstract void executeOnServer(EntitydataPlayerMP var1, ByteBuf var2);

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip() {
        return this.tooltipInfo;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public SkillSlot getSlot() {
        return this.slot;
    }

    public static enum SkillSlot {
        CLASS_ABILITY_1(0),
        CLASS_ABILITY_2(1),
        CLASS_ABILITY_3(2),
        CLASS_ABILITY_4(3),
        DODGE(4),
        WEAPON_SPECIAL_ATTACK(5);

        int index;

        private SkillSlot(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

