/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.skills;

import com.epicfight.capabilities.entity.player.EntitydataPlayer;
import com.epicfight.capabilities.entity.player.EntitydataPlayerMP;
import com.epicfight.client.capabilites.entity.EntitydataPlayerSP;
import com.epicfight.client.events.RenderEvents;
import com.epicfight.main.ModCore;
import com.epicfight.skills.Skill;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class SkillContainer {
    protected Skill containingSkill;
    protected float restricValue = 0.0f;
    protected float prevRestricValue = 0.0f;
    protected boolean flashToggle = true;

    public void setSkill(Skill skill) {
        this.containingSkill = skill;
        this.reset();
    }

    public void reset() {
        this.flashToggle = true;
        this.prevRestricValue = 0.0f;
        this.restricValue = 0.0f;
    }

    public boolean isEmpty() {
        return this.containingSkill == null;
    }

    public void setRestricValue(float value) {
        if (this.containingSkill != null) {
            if (value >= this.containingSkill.restriction && this.flashToggle && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.flashToggle = false;
                RenderEvents.guiSkillBar.notifyFlash(this.containingSkill.slot);
            }
            this.restricValue = value;
            this.restricValue = Math.max(this.restricValue, 0.0f);
            this.restricValue = Math.min(this.restricValue, this.containingSkill.restriction);
        } else {
            this.prevRestricValue = 0.0f;
            this.restricValue = 0.0f;
        }
    }

    public void execute(EntitydataPlayer executer, Object ... args) {
        if (this.canExecute(executer)) {
            this.containingSkill.executeOnClient((EntitydataPlayerSP)executer, args);
            this.reset();
        }
    }

    public boolean requestExecute(EntitydataPlayer executer, ByteBuf buf) {
        if (this.canExecute(executer)) {
            this.containingSkill.executeOnServer((EntitydataPlayerMP)executer, buf);
            this.reset();
            return true;
        }
        return false;
    }

    public float getRestricValue() {
        return this.restricValue;
    }

    public boolean canExecute(EntitydataPlayer<?> executer) {
        if (((EntityPlayer)executer.getOriginalEntity()).func_184812_l_()) {
            return true;
        }
        return this.containingSkill != null ? this.containingSkill.restriction <= this.restricValue : false;
    }

    public void update(float tick) {
        if (this.containingSkill != null) {
            this.prevRestricValue = this.restricValue;
            this.setRestricValue(this.restricValue + 0.05f * tick);
        }
    }

    public Skill getSkill() {
        return this.containingSkill;
    }

    public float getRenderRatio() {
        return this.containingSkill != null ? (this.prevRestricValue + (this.restricValue - this.prevRestricValue) * ModCore.partialTick) / this.containingSkill.restriction : 0.0f;
    }
}

