/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.utils.game;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;

public class AttackResult {
    private Entity attacker;
    private List<Double> distanceToAttacker;
    private List<Entity> hitEntites;
    private int index;

    public AttackResult(Entity attacker) {
        this.attacker = attacker;
        this.distanceToAttacker = Lists.newArrayList();
        this.hitEntites = Lists.newArrayList();
        this.index = 0;
    }

    public AttackResult(Entity attacker, List<Entity> entities) {
        this(attacker);
        this.addEntities(entities);
    }

    private void addEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            this.addNewEntity(entity);
        }
    }

    private void addNewEntity(Entity newHitEntity) {
        int index;
        double distance = this.attacker.func_70068_e(newHitEntity);
        for (index = 0; index < this.hitEntites.size(); ++index) {
            if (!(distance < this.distanceToAttacker.get(index))) continue;
            this.hitEntites.add(index, newHitEntity);
            this.distanceToAttacker.add(index, distance);
            return;
        }
        this.hitEntites.add(index, newHitEntity);
        this.distanceToAttacker.add(index, distance);
    }

    public Entity getEntity() {
        return this.hitEntites.get(this.index);
    }

    public boolean next() {
        ++this.index;
        return this.hitEntites.size() > this.index;
    }
}

