/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.utils.game;

import com.epicfight.capabilities.ModCapabilities;
import com.epicfight.capabilities.entity.EntitydataFighter;
import com.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntityDamageSource;

public class DamageSourceExtended
extends EntityDamageSource
implements IExtendedDamageSource {
    private float impact;
    private float armorIgnore;
    private IExtendedDamageSource.StunType stunType;

    public DamageSourceExtended(String damageTypeIn, Entity damageSourceEntityIn, IExtendedDamageSource.StunType stunType) {
        super(damageTypeIn, damageSourceEntityIn);
        EntitydataFighter entityCap = (EntitydataFighter)damageSourceEntityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        this.stunType = stunType;
        this.impact = entityCap.getImpact();
        this.armorIgnore = entityCap.getDefenceIgnore();
    }

    @Override
    public void setImpact(float amount) {
        this.impact = amount;
    }

    @Override
    public void setArmorIgnore(float amount) {
        this.armorIgnore = amount;
    }

    @Override
    public void setStunType(IExtendedDamageSource.StunType type) {
        this.stunType = type;
    }

    @Override
    public float getImpact() {
        return this.impact;
    }

    @Override
    public float getArmorIgnoreRatio() {
        return this.armorIgnore * 0.01f;
    }

    @Override
    public IExtendedDamageSource.StunType getStunType() {
        return this.stunType;
    }
}

