/*
 * Decompiled with CFR 0.152.
 */
package com.epicfight.utils.math;

import com.epicfight.main.ModCore;
import com.epicfight.utils.math.Mat4f;
import com.epicfight.utils.math.Vec3f;
import com.epicfight.utils.math.Vec4f;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MathUtils {
    public static FloatBuffer projection;
    public static FloatBuffer view;
    private Field lightmapField;

    public MathUtils() {
        projection = GLAllocation.func_74529_h((int)16);
        view = GLAllocation.func_74529_h((int)16);
        this.lightmapField = ObfuscationReflectionHelper.findField(EntityRenderer.class, (String)"field_78504_Q");
    }

    public static Mat4f getModelMatrixIntegrated(float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw) {
        Mat4f modelMatrix = new Mat4f().setIdentity();
        float partialTick = ModCore.partialTick;
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        Mat4f.translate(entityPosition, modelMatrix, modelMatrix);
        float pitchDegree = MathUtils.interpolateRotation(prevPitch, pitch, partialTick);
        float yawyDegree = MathUtils.interpolateRotation(prevYaw, yaw, partialTick);
        Mat4f.rotate((float)(-Math.toRadians(yawyDegree)), new Vec3f(0.0f, 1.0f, 0.0f), modelMatrix, modelMatrix);
        Mat4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), modelMatrix, modelMatrix);
        return modelMatrix;
    }

    public static Mat4f getModelMatrixIntegrated(Mat4f mat, float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw) {
        if (mat == null) {
            mat = new Mat4f().setIdentity();
        }
        float partialTick = ModCore.partialTick;
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        Mat4f.translate(entityPosition, mat, mat);
        float pitchDegree = MathUtils.interpolateRotation(prevPitch, pitch, partialTick);
        float yawyDegree = MathUtils.interpolateRotation(prevYaw, yaw, partialTick);
        Mat4f.rotate((float)(-Math.toRadians(yawyDegree)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
        Mat4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
        return mat;
    }

    @SideOnly(value=Side.CLIENT)
    public static Mat4f getViewMatrix() {
        Mat4f viewMatrix = new Mat4f();
        viewMatrix.load(view.asReadOnlyBuffer());
        float partialTick = ModCore.partialTick;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        Vec3f cameraPosition = new Vec3f((float)(camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)partialTick), -((float)(camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)partialTick + (double)Minecraft.func_71410_x().func_175606_aa().func_70047_e())), (float)(camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)partialTick));
        Mat4f.rotate((float)Math.toRadians(camera.field_70127_C + (camera.field_70125_A - camera.field_70127_C) * partialTick), new Vec3f(1.0f, 0.0f, 0.0f), viewMatrix, viewMatrix);
        Mat4f.rotate((float)Math.toRadians(camera.field_70126_B + (camera.field_70177_z - camera.field_70126_B) * partialTick), new Vec3f(0.0f, 1.0f, 0.0f), viewMatrix, viewMatrix);
        Mat4f.translate(cameraPosition, viewMatrix, viewMatrix);
        return viewMatrix;
    }

    @SideOnly(value=Side.CLIENT)
    public Mat4f getCurrentProjectionMatrix() {
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)projection);
        Mat4f projectionMatrix = new Mat4f().load(projection.asReadOnlyBuffer());
        return projectionMatrix;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3f getTotalLight(int sky, int block) {
        try {
            int[] colorMap = (int[])this.lightmapField.get(Minecraft.func_71410_x().field_71460_t);
            Vec4f color = this.convertColorToVector(colorMap[sky * 16 + block]);
            return new Vec3f(color.x, color.y, color.z);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            System.err.println("[ModError] : colormap reflection error");
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec4f convertColorToVector(int color) {
        float r = (float)(color & 0xFF) / 255.0f;
        float g = (float)((color >>= 8) & 0xFF) / 255.0f;
        float b = (float)((color >>= 8) & 0xFF) / 255.0f;
        Vec4f colorVector = new Vec4f(b, g, r, 1.0f);
        return colorVector;
    }

    public static float interpolateRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par1 + par3 * f;
    }

    public static float getInterpolatedRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par3 * f;
    }
}

