/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation;

import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.animation.types.LinkAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.utils.math.Mat4f;

public class AnimatorServer
extends Animator {
    public final AnimationPlayer animationPlayer;
    protected DynamicAnimation nextPlaying;
    private LinkAnimation linkAnimation;
    public boolean pause = false;

    public AnimatorServer(LivingData<?> modEntity) {
        this.entitydata = modEntity;
        this.linkAnimation = new LinkAnimation();
        this.animationPlayer = new AnimationPlayer(Animations.DUMMY_ANIMATION);
    }

    @Override
    public void playAnimation(int id, float modifyTime) {
        this.playAnimation(Animations.findAnimationDataById(id), modifyTime);
    }

    @Override
    public void playAnimation(StaticAnimation nextAnimation, float modifyTime) {
        this.pause = false;
        this.animationPlayer.getPlay().onFinish(this.entitydata, this.animationPlayer.isEnd());
        nextAnimation.onActivate(this.entitydata);
        nextAnimation.getLinkAnimation(Animations.DUMMY_ANIMATION.getPoseByTime(this.entitydata, 0.0f), modifyTime, this.entitydata, this.linkAnimation);
        this.linkAnimation.putOnPlayer(this.animationPlayer);
        this.nextPlaying = nextAnimation;
    }

    @Override
    public void vacateCurrentPlay() {
        this.animationPlayer.setPlayAnimation(Animations.DUMMY_ANIMATION);
    }

    @Override
    public void update() {
        if (this.pause) {
            return;
        }
        this.animationPlayer.update(0.05f * this.animationPlayer.getPlay().getPlaySpeed(this.entitydata));
        this.animationPlayer.getPlay().onUpdate(this.entitydata);
        if (this.animationPlayer.isEnd()) {
            this.animationPlayer.getPlay().onFinish(this.entitydata, true);
            if (this.nextPlaying == null) {
                Animations.DUMMY_ANIMATION.putOnPlayer(this.animationPlayer);
                this.pause = true;
            } else {
                this.nextPlaying.putOnPlayer(this.animationPlayer);
                this.nextPlaying = null;
            }
        }
    }

    public Mat4f getColliderTransformMatrix(int indexer) {
        if (indexer == -1) {
            return new Mat4f();
        }
        return this.applyPoseToCollider(this.getCurrentPose(), this.entitydata.getEntityModel().getArmature().getJointHierarcy(), new Mat4f(), indexer);
    }

    private Mat4f applyPoseToCollider(Pose pose, Joint joint, Mat4f parentTransform, int indexer) {
        Mat4f currentLocalTransform = pose.getTransformByName(joint.getName()).toTransformMatrix();
        Mat4f.mul(joint.getLocalTrasnform(), currentLocalTransform, currentLocalTransform);
        Mat4f bindTransform = Mat4f.mul(parentTransform, currentLocalTransform, null);
        Mat4f.mul(bindTransform, joint.getAnimatedTransform(), bindTransform);
        joint.setAnimatedTransform(bindTransform);
        if ((indexer >>= 5) == 0) {
            return bindTransform;
        }
        return this.applyPoseToCollider(pose, joint.getSubJoints().get((indexer & 0x1F) - 1), bindTransform, indexer);
    }

    protected Pose getCurrentPose() {
        return this.animationPlayer.getCurrentPose(this.entitydata, 0.5f);
    }

    @Override
    public void onEntityDeath() {
        if (this.animationPlayer.getPlay() != null) {
            this.animationPlayer.getPlay().onFinish(this.entitydata, this.animationPlayer.isEnd());
        }
        if (this.nextPlaying != null) {
            this.nextPlaying.onFinish(this.entitydata, false);
        }
    }

    @Override
    public AnimationPlayer getPlayer() {
        return this.animationPlayer;
    }

    @Override
    public AnimationPlayer getPlayerFor(StaticAnimation animation) {
        return this.animationPlayer;
    }
}

