/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation;

import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;

public class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.normalize();
    }

    public void normalize() {
        float mag = (float)Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        this.w /= mag;
        this.x /= mag;
        this.y /= mag;
        this.z /= mag;
    }

    public Mat4f toRotationMatrix() {
        Mat4f matrix = new Mat4f();
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zw = this.z * this.w;
        float xSquared = this.x * this.x;
        float ySquared = this.y * this.y;
        float zSquared = this.z * this.z;
        matrix.m00 = 1.0f - 2.0f * (ySquared + zSquared);
        matrix.m01 = 2.0f * (xy - zw);
        matrix.m02 = 2.0f * (xz + yw);
        matrix.m03 = 0.0f;
        matrix.m10 = 2.0f * (xy + zw);
        matrix.m11 = 1.0f - 2.0f * (xSquared + zSquared);
        matrix.m12 = 2.0f * (yz - xw);
        matrix.m13 = 0.0f;
        matrix.m20 = 2.0f * (xz - yw);
        matrix.m21 = 2.0f * (yz + xw);
        matrix.m22 = 1.0f - 2.0f * (xSquared + ySquared);
        matrix.m23 = 0.0f;
        matrix.m30 = 0.0f;
        matrix.m31 = 0.0f;
        matrix.m32 = 0.0f;
        matrix.m33 = 1.0f;
        return matrix;
    }

    public static Quaternion fromMatrix(Mat4f matrix) {
        float z;
        float y;
        float x;
        float w;
        float diagonal = matrix.m00 + matrix.m11 + matrix.m22;
        if (diagonal > 0.0f) {
            float w4 = (float)(Math.sqrt(diagonal + 1.0f) * 2.0);
            w = w4 / 4.0f;
            x = (matrix.m21 - matrix.m12) / w4;
            y = (matrix.m02 - matrix.m20) / w4;
            z = (matrix.m10 - matrix.m01) / w4;
        } else if (matrix.m00 > matrix.m11 && matrix.m00 > matrix.m22) {
            float x4 = (float)(Math.sqrt(1.0f + matrix.m00 - matrix.m11 - matrix.m22) * 2.0);
            w = (matrix.m21 - matrix.m12) / x4;
            x = x4 / 4.0f;
            y = (matrix.m01 + matrix.m10) / x4;
            z = (matrix.m02 + matrix.m20) / x4;
        } else if (matrix.m11 > matrix.m22) {
            float y4 = (float)(Math.sqrt(1.0f + matrix.m11 - matrix.m00 - matrix.m22) * 2.0);
            w = (matrix.m02 - matrix.m20) / y4;
            x = (matrix.m01 + matrix.m10) / y4;
            y = y4 / 4.0f;
            z = (matrix.m12 + matrix.m21) / y4;
        } else {
            float z4 = (float)(Math.sqrt(1.0f + matrix.m22 - matrix.m00 - matrix.m11) * 2.0);
            w = (matrix.m10 - matrix.m01) / z4;
            x = (matrix.m02 + matrix.m20) / z4;
            y = (matrix.m12 + matrix.m21) / z4;
            z = z4 / 4.0f;
        }
        return new Quaternion(x, y, z, w);
    }

    public static Quaternion interpolate(Quaternion a, Quaternion b, float blend) {
        Quaternion result = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        float dot = a.w * b.w + a.x * b.x + a.y * b.y + a.z * b.z;
        float blendI = 1.0f - blend;
        if (dot < 0.0f) {
            result.w = blendI * a.w + blend * -b.w;
            result.x = blendI * a.x + blend * -b.x;
            result.y = blendI * a.y + blend * -b.y;
            result.z = blendI * a.z + blend * -b.z;
        } else {
            result.w = blendI * a.w + blend * b.w;
            result.x = blendI * a.x + blend * b.x;
            result.y = blendI * a.y + blend * b.y;
            result.z = blendI * a.z + blend * b.z;
        }
        result.normalize();
        return result;
    }

    public static Quaternion rotate(float degree, Vec3f axis, Quaternion src) {
        Mat4f quatmat = src.toRotationMatrix();
        Mat4f rotMat = new Mat4f();
        Mat4f.rotate(degree, axis, rotMat, rotMat);
        Mat4f.mul(quatmat, rotMat, quatmat);
        return Quaternion.fromMatrix(quatmat);
    }

    public String toString() {
        return String.format("%f %f %f %f", Float.valueOf(this.w), Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

