/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation;

import java.util.List;
import maninhouse.epicfight.animation.JointKeyframe;
import maninhouse.epicfight.animation.JointTransform;

public class TransformSheet {
    private final JointKeyframe[] keyframes;

    public TransformSheet(List<JointKeyframe> keyframeList) {
        JointKeyframe[] keyframes = new JointKeyframe[keyframeList.size()];
        for (int i = 0; i < keyframeList.size(); ++i) {
            keyframes[i] = keyframeList.get(i);
        }
        this.keyframes = keyframes;
    }

    public TransformSheet(JointKeyframe[] keyframes) {
        this.keyframes = keyframes;
    }

    public JointTransform getStartTransform() {
        return this.keyframes[0].getTransform();
    }

    public JointTransform getInterpolatedTransform(float currentTime) {
        int prev = 0;
        int next = 1;
        for (int i = 1; i < this.keyframes.length && !(currentTime <= this.keyframes[i].getTimeStamp()); ++i) {
            if (this.keyframes.length > next + 1) {
                ++prev;
                ++next;
                continue;
            }
            System.err.println("[ModError] : time exceeded keyframe length");
        }
        float progression = (currentTime - this.keyframes[prev].getTimeStamp()) / (this.keyframes[next].getTimeStamp() - this.keyframes[prev].getTimeStamp());
        JointTransform trasnform = JointTransform.interpolate(this.keyframes[prev].getTransform(), this.keyframes[next].getTransform(), progression);
        return trasnform;
    }
}

