/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.JointTransform;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.TransformSheet;
import maninhouse.epicfight.animation.types.ImmovableAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.entity.event.EntityEventListener;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;

public class ActionAnimation
extends ImmovableAnimation {
    protected final boolean breakMovement;
    protected final boolean affectYCoord;
    protected float delayTime;

    public ActionAnimation(int id, float convertTime, boolean breakMove, boolean affectY, String path) {
        this(id, convertTime, -1.0f, breakMove, affectY, path);
    }

    public ActionAnimation(int id, float convertTime, float postDelay, boolean breakMove, boolean affectY, String path) {
        super(id, convertTime, path);
        this.breakMovement = breakMove;
        this.affectYCoord = affectY;
        this.delayTime = postDelay;
    }

    @Override
    public void onActivate(LivingData<?> entity) {
        super.onActivate(entity);
        Object orgEntity = entity.getOriginalEntity();
        float yaw = ((Entity)orgEntity).field_70177_z;
        orgEntity.func_70034_d(yaw);
        orgEntity.func_181013_g(yaw);
        if (this.breakMovement) {
            entity.getOriginalEntity().func_213293_j(0.0, orgEntity.func_213322_ci().field_72448_b, 0.0);
        }
        if (entity instanceof PlayerData) {
            ((PlayerData)entity).getEventListener().activateEvents(EntityEventListener.Event.ON_ACTION_SERVER_EVENT);
        }
    }

    @Override
    public void onUpdate(LivingData<?> entity) {
        super.onUpdate(entity);
        Object livingentity = entity.getOriginalEntity();
        if (entity.isRemote()) {
            if (!(livingentity instanceof ClientPlayerEntity)) {
                return;
            }
            if (livingentity instanceof ServerPlayerEntity) {
                return;
            }
        }
        if (entity.isInaction()) {
            BlockPos blockpos = new BlockPos(((LivingEntity)livingentity).field_70165_t, livingentity.func_174813_aQ().field_72338_b - 1.0, ((LivingEntity)livingentity).field_70161_v);
            float f5 = ((LivingEntity)livingentity).field_70170_p.func_180495_p(blockpos).getSlipperiness((IWorldReader)((LivingEntity)livingentity).field_70170_p, blockpos, livingentity);
            float friction = ((LivingEntity)livingentity).field_70122_E ? f5 * 0.91f : 0.91f;
            livingentity.func_213317_d(livingentity.func_213322_ci().func_178788_d(new Vec3d((double)entity.prevMotion.x, (double)entity.prevMotion.y, (double)entity.prevMotion.z).func_186678_a((double)friction)));
            Vec3f vec3 = this.getCoordVector(entity);
            entity.prevMotion.x = vec3.x;
            entity.prevMotion.y = vec3.y;
            entity.prevMotion.z = vec3.z;
            livingentity.func_213317_d(livingentity.func_213322_ci().func_72441_c((double)vec3.x, (double)vec3.y, (double)vec3.z));
        }
    }

    @Override
    public void onFinish(LivingData<?> entity, boolean isEnd) {
        super.onFinish(entity, isEnd);
        entity.prevMotion.scale(0.0f);
    }

    @Override
    public LivingData.EntityState getState(float time) {
        if (time < this.delayTime) {
            return LivingData.EntityState.PRE_DELAY;
        }
        return LivingData.EntityState.FREE_INPUT;
    }

    @Override
    public Pose getPoseByTime(LivingData<?> entity, float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            JointTransform jt = ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(time);
            if (jointName.equals("Root")) {
                Vec3f vec = jt.getPosition();
                vec.x = 0.0f;
                vec.y = this.affectYCoord ? 0.0f : vec.y;
                vec.z = 0.0f;
            }
            pose.putJointData(jointName, jt);
        }
        return pose;
    }

    @Override
    public StaticAnimation bindFull(Armature armature) {
        super.bindFull(armature);
        if (this.delayTime < 0.0f) {
            this.delayTime = this.totalTime;
        }
        return this;
    }

    protected Vec3f getCoordVector(LivingData<?> entitydata) {
        Object elb = entitydata.getOriginalEntity();
        JointTransform jt = ((TransformSheet)this.jointTransforms.get("Root")).getInterpolatedTransform(((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime());
        JointTransform prevJt = ((TransformSheet)this.jointTransforms.get("Root")).getInterpolatedTransform(((Animator)entitydata.getAnimator()).getPlayer().getPrevElapsedTime());
        Vec4f currentPos = new Vec4f(jt.getPosition().x, jt.getPosition().y, jt.getPosition().z, 1.0f);
        Vec4f prevPos = new Vec4f(prevJt.getPosition().x, prevJt.getPosition().y, prevJt.getPosition().z, 1.0f);
        Mat4f mat = entitydata.getModelMatrix(1.0f);
        mat.m30 = 0.0f;
        mat.m31 = 0.0f;
        mat.m32 = 0.0f;
        Mat4f.transform(mat, currentPos, currentPos);
        Mat4f.transform(mat, prevPos, prevPos);
        float dx = prevPos.x - currentPos.x;
        float dy = this.affectYCoord ? currentPos.y - prevPos.y : 0.0f;
        float dz = prevPos.z - currentPos.z;
        if (this.affectYCoord && dy > 0.0f) {
            Vec3d motion = elb.func_213322_ci();
            elb.func_213293_j(motion.field_72450_a, Math.min(motion.field_72448_b + 0.8, 0.0) + 0.08, motion.field_72449_c);
        }
        return new Vec3f(dx, dy, dz);
    }
}

