/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import java.util.HashMap;
import java.util.Map;
import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.JointKeyframe;
import maninhouse.epicfight.animation.JointTransform;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.TransformSheet;
import maninhouse.epicfight.animation.types.LinkAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;

public class DynamicAnimation {
    protected final Map<String, TransformSheet> jointTransforms = new HashMap<String, TransformSheet>();
    protected final boolean isRepeat;
    protected final float convertTime;
    protected float totalTime;

    public DynamicAnimation() {
        this.totalTime = 0.0f;
        this.isRepeat = false;
        this.convertTime = 0.16f;
    }

    public DynamicAnimation(float convertTime, boolean isRepeat) {
        this(0.0f, convertTime, isRepeat);
    }

    public DynamicAnimation(float totalTime, float convertTime, boolean isRepeat) {
        this.totalTime = totalTime;
        this.isRepeat = isRepeat;
        this.convertTime = convertTime;
    }

    public void addSheet(String jointName, TransformSheet sheet) {
        this.jointTransforms.put(jointName, sheet);
    }

    public Pose getPoseByTime(LivingData<?> entitydata, float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            pose.putJointData(jointName, this.jointTransforms.get(jointName).getInterpolatedTransform(time));
        }
        return pose;
    }

    public void getLinkAnimation(Pose pose1, float timeModifier, LivingData<?> entitydata, LinkAnimation dest) {
        float nextStart;
        float totalTime = timeModifier >= 0.0f ? timeModifier + this.convertTime : this.convertTime;
        boolean isNeg = timeModifier < 0.0f;
        float f = nextStart = isNeg ? -timeModifier : 0.0f;
        if (isNeg) {
            dest.startsAt = nextStart;
        }
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setNextAnimation(this);
        Map<String, JointTransform> data1 = pose1.getJointTransformData();
        Map<String, JointTransform> data2 = this.getPoseByTime(entitydata, nextStart).getJointTransformData();
        for (String jointName : data1.keySet()) {
            JointKeyframe[] keyframes = new JointKeyframe[]{new JointKeyframe(0.0f, data1.get(jointName)), new JointKeyframe(totalTime, data2.get(jointName))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.addSheet(jointName, sheet);
        }
    }

    public void putOnPlayer(AnimationPlayer player) {
        player.setPlayAnimation(this);
    }

    public void onActivate(LivingData<?> entitydata) {
    }

    public void onUpdate(LivingData<?> entitydata) {
    }

    public void onFinish(LivingData<?> entitydata, boolean isEnd) {
    }

    public LivingData.EntityState getState(float time) {
        return LivingData.EntityState.FREE;
    }

    public Map<String, TransformSheet> getTransfroms() {
        return this.jointTransforms;
    }

    public float getPlaySpeed(LivingData<?> entitydata) {
        return 1.0f;
    }

    public void setTotalTime(float totalTime) {
        this.totalTime = totalTime;
    }

    public float getTotalTime() {
        return this.totalTime - 1.0E-6f;
    }

    public float getConvertTime() {
        return this.convertTime;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }
}

