/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types.attack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.types.ActionAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.game.AttackResult;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Mat4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;

public class AttackAnimation
extends ActionAnimation {
    protected final Phase[] phases;
    protected Map<DMGProperty, Property<?>> properties = new HashMap();
    private static final Map<DMGProperty, Class<? extends Property<?>>> damagePropertyMap = new HashMap();

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new Phase(antic, preDelay, contact, recovery, index, collider));
    }

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, Hand hand, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new Phase(antic, preDelay, contact, recovery, hand, index, collider));
    }

    public AttackAnimation(int id, float convertTime, boolean affectY, String path, Phase ... phases) {
        super(id, convertTime, true, affectY, path);
        this.phases = phases;
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        block8: {
            Phase phase;
            LivingData.EntityState state;
            float elapsedTime;
            block9: {
                super.onUpdate(entitydata);
                if (entitydata.isRemote()) break block8;
                elapsedTime = ((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime();
                state = this.getState(elapsedTime);
                phase = this.getCurrentPhase(elapsedTime);
                if (state != LivingData.EntityState.FREE_CAMERA) break block9;
                if (!(entitydata instanceof MobData)) break block8;
                MobEntity entity = (MobEntity)entitydata.getOriginalEntity();
                entity.func_70661_as().func_75499_g();
                if (entity.func_70638_az() != null) {
                    entitydata.rotateTo((Entity)entity.func_70638_az(), 60.0f, false);
                }
                break block8;
            }
            if (state == LivingData.EntityState.CONTACT) {
                if (this.getState(((Animator)entitydata.getAnimator()).getPlayer().getPrevElapsedTime()) != LivingData.EntityState.CONTACT) {
                    entitydata.playSound(this.getSwingSound(entitydata, phase.hand), 0.0f, 0.0f);
                    entitydata.currentlyAttackedEntity.clear();
                }
                Collider collider = this.getCollider(entitydata, elapsedTime);
                Object entity = entitydata.getOriginalEntity();
                entitydata.getEntityModel().getArmature().initializeTransform();
                Mat4f jointTransform = entitydata.getServerAnimator().getColliderTransformMatrix(phase.jointIndexer);
                collider.transform(Mat4f.mul(entitydata.getModelMatrix(1.0f), jointTransform, null));
                List list = ((LivingEntity)entity).field_70170_p.func_72839_b(entity, collider.getHitboxAABB());
                collider.extractHitEntities(list);
                if (list.size() > 0) {
                    AttackResult attackResult = new AttackResult((Entity)entity, list);
                    int i = 0;
                    while (entitydata.currentlyAttackedEntity.size() < this.getHitEnemies(entitydata)) {
                        Entity e = attackResult.getEntity();
                        if (!entitydata.currentlyAttackedEntity.contains(e) && !entitydata.isTeam(e) && e instanceof LivingEntity && ((LivingEntity)entity).field_70170_p.func_217299_a(new RayTraceContext(new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v), new Vec3d(((LivingEntity)entity).field_70165_t, ((LivingEntity)entity).field_70163_u + (double)(entity.func_213302_cg() * 0.5f), ((LivingEntity)entity).field_70161_v), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS) {
                            IExtendedDamageSource source = this.getDamageSourceExt(entitydata, e);
                            if (entitydata.hurtEntity(e, source, this.getDamageAmount(entitydata, e, phase.hand))) {
                                entity.func_130011_c(e);
                                e.field_70172_ad = 0;
                                e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, this.getHitSound(entitydata, phase.hand), e.func_184176_by(), 1.0f, 1.0f);
                                this.spawnHitParticle((ServerWorld)e.field_70170_p, entitydata, e, phase.hand);
                                if (i == 0 && entitydata instanceof PlayerData) {
                                    entitydata.getOriginalEntity().func_184614_ca().func_77961_a((LivingEntity)e, (PlayerEntity)((PlayerData)entitydata).getOriginalEntity());
                                }
                                ++i;
                            }
                            entitydata.currentlyAttackedEntity.add(e);
                        }
                        if (attackResult.next()) continue;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void onFinish(LivingData<?> entitydata, boolean isEnd) {
        MobEntity entity;
        super.onFinish(entitydata, isEnd);
        entitydata.currentlyAttackedEntity.clear();
        if (entitydata instanceof BipedMobData && entitydata.isRemote() && (entity = (MobEntity)entitydata.getOriginalEntity()).func_70638_az() != null && !entity.func_70638_az().func_70089_S()) {
            entity.func_70624_b((LivingEntity)null);
        }
    }

    @Override
    public LivingData.EntityState getState(float time) {
        Phase phase = this.getCurrentPhase(time);
        if (phase.antic >= time) {
            return LivingData.EntityState.FREE_CAMERA;
        }
        if (phase.antic < time && phase.preDelay >= time) {
            return LivingData.EntityState.PRE_DELAY;
        }
        if (phase.preDelay < time && phase.contact >= time) {
            return LivingData.EntityState.CONTACT;
        }
        if (phase.recovery > time) {
            return LivingData.EntityState.POST_DELAY;
        }
        return LivingData.EntityState.FREE_INPUT;
    }

    public Collider getCollider(LivingData<?> entitydata, float elapsedTime) {
        Phase phase = this.getCurrentPhase(elapsedTime);
        return phase.collider != null ? phase.collider : entitydata.getColliderMatching(phase.hand);
    }

    protected int getHitEnemies(LivingData<?> entitydata) {
        return this.properties.containsKey((Object)DMGProperty.HIT_AT_ONCE) ? ((Integer)this.properties.get((Object)DMGProperty.HIT_AT_ONCE).getValue()).intValue() : entitydata.getHitEnemies();
    }

    protected float getDamageAmount(LivingData<?> entitydata, Entity target, Hand hand) {
        float multiplier = this.properties.containsKey((Object)DMGProperty.DAMAGE_MULTIPLIER) ? ((Float)this.properties.get((Object)DMGProperty.DAMAGE_MULTIPLIER).getValue()).floatValue() : 1.0f;
        float adder = this.properties.containsKey((Object)DMGProperty.DAMAGE_ADDER) ? ((Float)this.properties.get((Object)DMGProperty.DAMAGE_ADDER).getValue()).floatValue() : 0.0f;
        return entitydata.getDamageToEntity(target, hand) * multiplier + adder;
    }

    protected SoundEvent getSwingSound(LivingData<?> entitydata, Hand hand) {
        return this.properties.containsKey((Object)DMGProperty.SWING_SOUND) ? (SoundEvent)this.properties.get((Object)DMGProperty.SWING_SOUND).getValue() : entitydata.getSwingSound(hand);
    }

    protected SoundEvent getHitSound(LivingData<?> entitydata, Hand hand) {
        return this.properties.containsKey((Object)DMGProperty.HIT_SOUND) ? (SoundEvent)this.properties.get((Object)DMGProperty.HIT_SOUND).getValue() : entitydata.getWeaponHitSound(hand);
    }

    protected IExtendedDamageSource getDamageSourceExt(LivingData<?> entitydata, Entity target) {
        IExtendedDamageSource.DamageType dmgType = this.properties.containsKey((Object)DMGProperty.DAMAGE_TYPE) ? (IExtendedDamageSource.DamageType)((Object)this.properties.get((Object)DMGProperty.DAMAGE_TYPE).getValue()) : IExtendedDamageSource.DamageType.PHYSICAL;
        IExtendedDamageSource.StunType stunType = this.properties.containsKey((Object)DMGProperty.STUN_TYPE) ? (IExtendedDamageSource.StunType)((Object)this.properties.get((Object)DMGProperty.STUN_TYPE).getValue()) : IExtendedDamageSource.StunType.SHORT;
        IExtendedDamageSource extDmgSource = entitydata.getDamageSource(stunType, dmgType, this.getId());
        if (this.properties.containsKey((Object)DMGProperty.ARMOR_IGNORANCE)) {
            extDmgSource.setArmorIgnore(((Float)this.properties.get((Object)DMGProperty.ARMOR_IGNORANCE).getValue()).floatValue());
        }
        if (this.properties.containsKey((Object)DMGProperty.IMPACT)) {
            extDmgSource.setImpact(((Float)this.properties.get((Object)DMGProperty.IMPACT).getValue()).floatValue());
        }
        if (this.properties.containsKey((Object)DMGProperty.SURESTRIKE)) {
            extDmgSource.setSureStrike(true);
        }
        return extDmgSource;
    }

    protected void spawnHitParticle(ServerWorld world, LivingData<?> attacker, Entity hit, Hand hand) {
        HitParticleType particle = this.properties.containsKey((Object)DMGProperty.PARTICLE) ? (HitParticleType)((RegistryObject)this.properties.get((Object)DMGProperty.PARTICLE).getValue()).get() : attacker.getWeaponHitParticle(hand);
        particle.spawnParticleWithArgument(world, HitParticleType.DEFAULT, hit, (Entity)attacker.getOriginalEntity());
    }

    public int getIndexer(float elapsedTime) {
        return this.getCurrentPhase((float)elapsedTime).jointIndexer;
    }

    public <T> AttackAnimation addProperty(DMGProperty proptype, T prop) {
        Property<?> property = null;
        try {
            property = damagePropertyMap.get((Object)proptype).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        if (property != null) {
            property.setValue(prop);
            this.properties.put(proptype, property);
        }
        return this;
    }

    public Phase getCurrentPhase(float elapsedTime) {
        Phase currentPhase = null;
        Phase[] phaseArray = this.phases;
        int n = phaseArray.length;
        for (int i = 0; i < n; ++i) {
            Phase phase;
            currentPhase = phase = phaseArray[i];
            if (phase.recovery > elapsedTime) break;
        }
        return currentPhase;
    }

    @Deprecated
    public void changeCollider(Collider newCollider, int index) {
        this.phases[index].collider = newCollider;
    }

    static {
        damagePropertyMap.put(DMGProperty.HIT_AT_ONCE, IntegerProperty.class);
        damagePropertyMap.put(DMGProperty.DAMAGE_MULTIPLIER, FloatProperty.class);
        damagePropertyMap.put(DMGProperty.DAMAGE_ADDER, FloatProperty.class);
        damagePropertyMap.put(DMGProperty.ARMOR_IGNORANCE, FloatProperty.class);
        damagePropertyMap.put(DMGProperty.IMPACT, FloatProperty.class);
        damagePropertyMap.put(DMGProperty.DAMAGE_TYPE, DamageTypeProperty.class);
        damagePropertyMap.put(DMGProperty.STUN_TYPE, StunTypeProperty.class);
        damagePropertyMap.put(DMGProperty.SWING_SOUND, SoundProperty.class);
        damagePropertyMap.put(DMGProperty.HIT_SOUND, SoundProperty.class);
        damagePropertyMap.put(DMGProperty.SURESTRIKE, NullProperty.class);
        damagePropertyMap.put(DMGProperty.PARTICLE, ParticleProperty.class);
    }

    public static class ParticleProperty
    extends Property<RegistryObject<HitParticleType>> {
    }

    public static class NullProperty
    extends Property<Object> {
    }

    public static class SoundProperty
    extends Property<SoundEvent> {
    }

    public static class StunTypeProperty
    extends Property<IExtendedDamageSource.StunType> {
    }

    public static class DamageTypeProperty
    extends Property<IExtendedDamageSource.DamageType> {
    }

    public static class FloatProperty
    extends Property<Float> {
    }

    public static class IntegerProperty
    extends Property<Integer> {
    }

    public static class Property<T> {
        T value;

        public void setValue(T t) {
            this.value = t;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static enum DMGProperty {
        HIT_AT_ONCE,
        DAMAGE_MULTIPLIER,
        DAMAGE_ADDER,
        ARMOR_IGNORANCE,
        IMPACT,
        DAMAGE_TYPE,
        STUN_TYPE,
        SWING_SOUND,
        HIT_SOUND,
        SURESTRIKE,
        PARTICLE;

    }

    public static class Phase {
        protected final float antic;
        protected final float preDelay;
        protected final float contact;
        protected final float recovery;
        protected final int jointIndexer;
        protected final Hand hand;
        protected Collider collider;

        public Phase(float antic, float preDelay, float contact, float recovery, String indexer, Collider collider) {
            this(antic, preDelay, contact, recovery, Hand.MAIN_HAND, indexer, collider);
        }

        public Phase(float antic, float preDelay, float contact, float recovery, Hand hand, String indexer, Collider collider) {
            this.antic = antic;
            this.preDelay = preDelay;
            this.contact = contact;
            this.recovery = recovery;
            this.collider = collider;
            this.hand = hand;
            int coded = 0;
            if (indexer.length() == 0) {
                this.jointIndexer = -1;
            } else {
                for (int i = 0; i < indexer.length(); ++i) {
                    int value = indexer.charAt(i) - 48;
                    coded |= value;
                    coded <<= 5;
                }
                this.jointIndexer = coded;
            }
        }
    }
}

