/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.item.AxeCapability;
import maninhouse.epicfight.capabilities.item.BowCapability;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.CrossbowCapability;
import maninhouse.epicfight.capabilities.item.HoeCapability;
import maninhouse.epicfight.capabilities.item.PickaxeCapability;
import maninhouse.epicfight.capabilities.item.ShovelCapability;
import maninhouse.epicfight.capabilities.item.SwordCapability;
import maninhouse.epicfight.capabilities.item.TridentCapability;
import maninhouse.epicfight.capabilities.item.VanillaArmorCapability;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class ProviderItem
implements ICapabilityProvider,
NonNullSupplier<CapabilityItem> {
    private static final Map<Item, CapabilityItem> CAPABILITY_BY_INSTANCE = new HashMap<Item, CapabilityItem>();
    private static final Map<Class<? extends Item>, Function<Item, CapabilityItem>> CAPABILITY_BY_CLASS = new HashMap<Class<? extends Item>, Function<Item, CapabilityItem>>();
    private CapabilityItem capability;
    private LazyOptional<CapabilityItem> optional = LazyOptional.of((NonNullSupplier)this);

    public static void makeMap() {
        CAPABILITY_BY_INSTANCE.put(Items.field_151031_f, new BowCapability(Items.field_151031_f));
        CAPABILITY_BY_INSTANCE.put(Items.field_151053_p, new AxeCapability((IItemTier)ItemTier.WOOD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151049_t, new AxeCapability((IItemTier)ItemTier.STONE));
        CAPABILITY_BY_INSTANCE.put(Items.field_151036_c, new AxeCapability((IItemTier)ItemTier.IRON));
        CAPABILITY_BY_INSTANCE.put(Items.field_151006_E, new AxeCapability((IItemTier)ItemTier.GOLD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151056_x, new AxeCapability((IItemTier)ItemTier.DIAMOND));
        CAPABILITY_BY_INSTANCE.put(Items.field_151039_o, new PickaxeCapability((IItemTier)ItemTier.WOOD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151050_s, new PickaxeCapability((IItemTier)ItemTier.STONE));
        CAPABILITY_BY_INSTANCE.put(Items.field_151035_b, new PickaxeCapability((IItemTier)ItemTier.IRON));
        CAPABILITY_BY_INSTANCE.put(Items.field_151005_D, new PickaxeCapability((IItemTier)ItemTier.GOLD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151046_w, new PickaxeCapability((IItemTier)ItemTier.DIAMOND));
        CAPABILITY_BY_INSTANCE.put(Items.field_151017_I, new HoeCapability((IItemTier)ItemTier.WOOD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151018_J, new HoeCapability((IItemTier)ItemTier.STONE));
        CAPABILITY_BY_INSTANCE.put(Items.field_151019_K, new HoeCapability((IItemTier)ItemTier.IRON));
        CAPABILITY_BY_INSTANCE.put(Items.field_151013_M, new HoeCapability((IItemTier)ItemTier.GOLD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151012_L, new HoeCapability((IItemTier)ItemTier.DIAMOND));
        CAPABILITY_BY_INSTANCE.put(Items.field_151038_n, new ShovelCapability((IItemTier)ItemTier.WOOD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151051_r, new ShovelCapability((IItemTier)ItemTier.STONE));
        CAPABILITY_BY_INSTANCE.put(Items.field_151037_a, new ShovelCapability((IItemTier)ItemTier.IRON));
        CAPABILITY_BY_INSTANCE.put(Items.field_151011_C, new ShovelCapability((IItemTier)ItemTier.GOLD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151047_v, new ShovelCapability((IItemTier)ItemTier.DIAMOND));
        CAPABILITY_BY_INSTANCE.put(Items.field_151041_m, new SwordCapability((IItemTier)ItemTier.WOOD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151052_q, new SwordCapability((IItemTier)ItemTier.STONE));
        CAPABILITY_BY_INSTANCE.put(Items.field_151040_l, new SwordCapability((IItemTier)ItemTier.IRON));
        CAPABILITY_BY_INSTANCE.put(Items.field_151010_B, new SwordCapability((IItemTier)ItemTier.GOLD));
        CAPABILITY_BY_INSTANCE.put(Items.field_151048_u, new SwordCapability((IItemTier)ItemTier.DIAMOND));
        CAPABILITY_BY_INSTANCE.put(Items.field_151021_T, new VanillaArmorCapability((ArmorItem)Items.field_151021_T));
        CAPABILITY_BY_INSTANCE.put(Items.field_151027_R, new VanillaArmorCapability((ArmorItem)Items.field_151027_R));
        CAPABILITY_BY_INSTANCE.put(Items.field_151024_Q, new VanillaArmorCapability((ArmorItem)Items.field_151024_Q));
        CAPABILITY_BY_INSTANCE.put(Items.field_151026_S, new VanillaArmorCapability((ArmorItem)Items.field_151026_S));
        CAPABILITY_BY_INSTANCE.put(Items.field_151151_aj, new VanillaArmorCapability((ArmorItem)Items.field_151151_aj));
        CAPABILITY_BY_INSTANCE.put(Items.field_151171_ah, new VanillaArmorCapability((ArmorItem)Items.field_151171_ah));
        CAPABILITY_BY_INSTANCE.put(Items.field_151169_ag, new VanillaArmorCapability((ArmorItem)Items.field_151169_ag));
        CAPABILITY_BY_INSTANCE.put(Items.field_151149_ai, new VanillaArmorCapability((ArmorItem)Items.field_151149_ai));
        CAPABILITY_BY_INSTANCE.put(Items.field_151029_X, new VanillaArmorCapability((ArmorItem)Items.field_151029_X));
        CAPABILITY_BY_INSTANCE.put(Items.field_151023_V, new VanillaArmorCapability((ArmorItem)Items.field_151023_V));
        CAPABILITY_BY_INSTANCE.put(Items.field_151020_U, new VanillaArmorCapability((ArmorItem)Items.field_151020_U));
        CAPABILITY_BY_INSTANCE.put(Items.field_151022_W, new VanillaArmorCapability((ArmorItem)Items.field_151022_W));
        CAPABILITY_BY_INSTANCE.put(Items.field_151167_ab, new VanillaArmorCapability((ArmorItem)Items.field_151167_ab));
        CAPABILITY_BY_INSTANCE.put(Items.field_151030_Z, new VanillaArmorCapability((ArmorItem)Items.field_151030_Z));
        CAPABILITY_BY_INSTANCE.put(Items.field_151028_Y, new VanillaArmorCapability((ArmorItem)Items.field_151028_Y));
        CAPABILITY_BY_INSTANCE.put(Items.field_151165_aa, new VanillaArmorCapability((ArmorItem)Items.field_151165_aa));
        CAPABILITY_BY_INSTANCE.put(Items.field_151175_af, new VanillaArmorCapability((ArmorItem)Items.field_151175_af));
        CAPABILITY_BY_INSTANCE.put(Items.field_151163_ad, new VanillaArmorCapability((ArmorItem)Items.field_151163_ad));
        CAPABILITY_BY_INSTANCE.put(Items.field_151161_ac, new VanillaArmorCapability((ArmorItem)Items.field_151161_ac));
        CAPABILITY_BY_INSTANCE.put(Items.field_151173_ae, new VanillaArmorCapability((ArmorItem)Items.field_151173_ae));
        CAPABILITY_BY_INSTANCE.put(Items.field_222114_py, new CrossbowCapability());
        CAPABILITY_BY_INSTANCE.put(Items.field_203184_eO, new TridentCapability());
        CAPABILITY_BY_CLASS.put(SwordItem.class, SwordCapability::new);
        CAPABILITY_BY_CLASS.put(PickaxeItem.class, PickaxeCapability::new);
        CAPABILITY_BY_CLASS.put(AxeItem.class, AxeCapability::new);
        CAPABILITY_BY_CLASS.put(ShovelItem.class, ShovelCapability::new);
        CAPABILITY_BY_CLASS.put(HoeItem.class, HoeCapability::new);
        CAPABILITY_BY_CLASS.put(BowItem.class, BowCapability::new);
    }

    public ProviderItem(Item item) {
        this.capability = CAPABILITY_BY_INSTANCE.get(item);
        if (this.capability == null) {
            this.capability = this.makeCustomCapability(item);
            if (this.capability != null) {
                CAPABILITY_BY_INSTANCE.put(item, this.capability);
            }
        }
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    private CapabilityItem makeCustomCapability(Item item) {
        CapabilityItem cap = null;
        for (Class<?> clazz = item.getClass(); clazz != null && cap == null; clazz = clazz.getSuperclass()) {
            cap = CAPABILITY_BY_CLASS.getOrDefault(clazz, argIn -> null).apply(item);
        }
        return cap;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ModCapabilities.CAPABILITY_ITEM ? this.optional.cast() : LazyOptional.empty();
    }

    public CapabilityItem get() {
        return this.capability;
    }
}

